/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.mbeanapi;

import javax.management.MBeanException;
import com.sun.enterprise.admin.config.MBeanConfigException;

public interface IAuthRealmMBean 
{
    public String[] getUserNames() 
        throws MBeanException, MBeanConfigException;
    
    public String[] getGroupNames() 
        throws MBeanException, MBeanConfigException;
    
    public String[] getUserGroupNames(String userName) 
        throws MBeanException, MBeanConfigException;
    
    public void addUser(String userName, String password, String[] groupList)
        throws MBeanException, MBeanConfigException;
   
    public void removeUser(String userName) 
        throws MBeanException, MBeanConfigException;

    
    public void updateUser(String userName, String password, String[] groupList) 
        throws MBeanException, MBeanConfigException;       

}
