/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/valueaccessor/PropertyValueAccessorBase.java,v 1.3 2005/12/25 03:42:07 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:07 $
 */
package com.sun.enterprise.admin.dottedname.valueaccessor;


import com.sun.enterprise.admin.dottedname.DottedNameStrings;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.MBeanException;
import javax.management.InstanceNotFoundException;
import javax.management.AttributeNotFoundException;
import javax.management.RuntimeOperationsException;
import javax.management.JMException;

import javax.management.MBeanServerConnection;

public abstract class PropertyValueAccessorBase extends PrefixedValueAccessorBase
{
    abstract String getGetPropertyMethodName();
	abstract String getSetPropertyMethodName();
	abstract String getGetPropertiesMethodName();
    
    
    public PropertyValueAccessorBase(MBeanServerConnection conn, String prefix)
	{
		super( conn, prefix);
	}
  
    public Attribute getValue( ObjectName objectName, String valueName )
		throws java.io.IOException, ReflectionException, InstanceNotFoundException,
		AttributeNotFoundException
	{
		Attribute	result	= null;
		try
		{
			final Object value	= getMBS().invoke( objectName,
				getGetPropertyMethodName(), new Object [] { valueName }, 
				new String [] { "java.lang.String" } );
			result	= new Attribute( valueName, value );
		}
		catch( MBeanException e )
		{
			// method doesn't exist
			throw new AttributeNotFoundException( DottedNameStrings.getString(DottedNameStrings.ATTRIBUTE_NOT_FOUND_KEY, valueName ));
		}
		catch( ReflectionException e )
		{
			// method doesn't exist
			throw new AttributeNotFoundException(  DottedNameStrings.getString(DottedNameStrings.ATTRIBUTE_NOT_FOUND_KEY, valueName ));
		}
		return( result );
	}
	
    public Attribute
	setValue( final ObjectName objectName, final Attribute attr ) throws Exception
	{
	// NOTE: -Djmx.invoke.getters must be set for setProperty() to succeed
	// as a method invocation (in the unit tests)
	
	// note that if attr.getValue() is null, the property will be removed
		getMBS().invoke( objectName,
			getSetPropertyMethodName(), new Object [] { attr }, 
			new String [] { "javax.management.Attribute" } );
		
		return( attr );
	}
	
	
	public String [] getAllPropertyNames(ObjectName objectName )
		throws java.io.IOException, ReflectionException, InstanceNotFoundException
    {
        return getAllPropertyNames( objectName, false );
    }
	public String [] getAllPropertyNames(ObjectName objectName, boolean bIncludingPrefix )
		throws java.io.IOException, ReflectionException, InstanceNotFoundException
	{
		String	[]	names	= null;
		
		try
		{
			final AttributeList	props	= (AttributeList)getMBS().invoke( objectName,
					getGetPropertiesMethodName(), null, 
					null );
			names	= new String [ props.size() ];
			for( int i = 0; i < names.length; ++i )
			{
				final Attribute	attr	= (Attribute)props.get( i );
				if(bIncludingPrefix)
                    names[ i ]	= getDottedNamePrefix() + attr.getName();
                else
                    names[ i ]	= attr.getName();
			}
		}
		// getProperties() does not exist--do not log this--it will always happen
		// on MBeans that don't have properties.  Certain bugs in S1As interceptor
		// cause the wrong types of exceptions to be thrown, so we have to catch
		// several of them.  The correct one is ReflectionException
		catch( MBeanException e )
		{
			names	= new String [ 0 ];
		}
		catch( RuntimeOperationsException e )
		{
			names	= new String [ 0 ];
		}
		catch( ReflectionException e )
		{
			names	= new String [ 0 ];
		}
		
		return( names );
	}
    
    
}


