/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/DottedNameForValue.java,v 1.3 2005/12/25 03:42:02 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:02 $
 */
 
package com.sun.enterprise.admin.dottedname;

import java.util.List;
import com.sun.enterprise.admin.dottedname.valueaccessor.PrefixedValueSupport;


/* 
	A class which interprets a DottedName as containing a value name.
 */
public final class DottedNameForValue
{
	protected final DottedName	mDottedName;
	protected DottedName		mPrefix;
	protected String			mValueName;
	
		public
	DottedNameForValue( final DottedName	dottedName )
	{
		mDottedName	= dottedName;
		mValueName	= null;
		mPrefix		= init();
	}
	
	/**
		Examine the name and extract the name of the value, which could be either
		a plain name or a prefixed name.
	 */
		private DottedName
	init()
	{
		final List	parts		= mDottedName.getParts();
		final int	numParts	= parts.size();
		
		// the scope is first, then
		// there must be at least 1 part for there to be a value
		// example:  "domain.locale"
		if ( numParts == 0 )
		{
			final String	msg	= DottedNameStrings.getString(
					DottedNameStrings.NO_VALUE_NAME_SPECIFIED_KEY );
			throw new IllegalArgumentException( msg + " = " + mDottedName );
		}
		
		// the last part is the value name
		final String	lastPart	= (String)parts.get( numParts - 1 );
		int				numPrefixParts	= 0;
		
		// If the part preceeding the value name is prefix
		// then 
        PrefixedValueSupport prop_support = new PrefixedValueSupport(null);
        final String dottedName = DottedName.toString(mDottedName.getDomain(),
                                                mDottedName.getScope(),
                                                mDottedName.getParts(), false);
        final boolean  isPrefixed = prop_support.isPrefixedValueDottedName(dottedName);
		if ( isPrefixed )
		{
			mValueName		= prop_support.getPrefixedValueName(dottedName, true);
			numPrefixParts	= numParts - 2;
		}
		else
		{
			// it's a regular value name; does not include prefix
			mValueName		= lastPart;
			numPrefixParts	= numParts - 1;
		}
		
		return( DottedNameFactory.getInstance().get( DottedName.toString( mDottedName, numPrefixParts ) ) );
	}
		
		public DottedName
	getPrefix()
	{
		return( mPrefix );
	}
	
                public String
	getValueName()
	{
		assert( mValueName != null );
		return( mValueName );
	}
                
    public String toString() {
        return mDottedName.toString();
    }
}


