/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.ext.offline;

import java.util.Set;
import java.util.HashSet;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.config.ConfigElement;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.offline.OfflineDottedNamePrefixes;


/**
 */
public final class OfflineDottedNamePrefixesTest extends AMXTestBase
{
        public
    OfflineDottedNamePrefixesTest()
    {
    }

        private ObjectName
    ON( final String objectNameString )
    {
        return Util.newObjectName( objectNameString );
    }
    
		public void
	testGetInstance()
	{
	    assert OfflineDottedNamePrefixes.getInstance() != null;
	}
	
	private static final String DOMAIN="amx:j2eeType=X-DomainConfig,name=na";
	private static final String SERVER_CONFIG="amx:j2eeType=X-StandaloneServerConfig,name=server-config";
	
	    private String
	getPrefix( final String objectNameString )
	{
	    return getPrefix( ON( objectNameString ) );
	}
	
	   private String
	getPrefix( final ObjectName objectName )
	{
	    final OfflineDottedNamePrefixes prefixes    =
	        OfflineDottedNamePrefixes.getInstance();
	    
	    return prefixes.getPrefix( objectName );
	}
	
		public void
	testIllegal()
	{
	    try
	    {
	        assert( getPrefix( "amx:foo=bar" ) == null );
	        assert false;
	    }
	    catch( Exception e )
	    {
	    }
	}
	
		public void
	testGetPrefix()
	{
	    assert( getPrefix( DOMAIN ).equals( "domain" ) );
	    assert( getPrefix( SERVER_CONFIG ).equals( "server-config" ) );
	}
	
	    public void
	testAllAMXConfig()
	{
	    if ( getConnection() == null )
	    {
	        warning( "testAllAMXConfig: No MBeanServerConnection, skipping test" );
	        return;
	    }
	    
	    final Set<ConfigElement> all   = getTestUtil().getAllAMX( ConfigElement.class );
	    
	    final Set<String>   missing = new HashSet<String>();
	    for( final ConfigElement config : all )
	    {
	        final ObjectName    objectName = Util.getObjectName( config );
	        final String    prefix  = getPrefix( objectName );
	        if ( prefix == null )
	        {
	            missing.add( config.getJ2EEType() );
	        }
	        else
	        {
	            //trace( prefix );
	        }
	    }
	    
	    if ( missing.size() != 0 )
	    {
	        //warning( "The following j2eeTypes do not yet have prefix support: " + NEWLINE +
	            //CollectionUtil.toString( missing, NEWLINE ) );
	    }
	}
}






















