/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.management.ext.logging;

import java.util.Set;

import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.helper.StatefulLoggingHelper;

import com.sun.appserv.management.ext.logging.Logging;
import static com.sun.appserv.management.ext.logging.Logging.*;
import com.sun.appserv.management.ext.logging.LogQueryResult;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


/**
    Test the StatefulLoggingHelper.
 */
public final class StatefulLoggingHelperTest extends AMXTestBase
{
		public
	StatefulLoggingHelperTest( )
	{
	}
	
	    final Set<Logging>
	getAllLogging()
	{
	    return getQueryMgr().queryJ2EETypeSet( XTypes.LOGGING );
	}
	
	    public StatefulLoggingHelper
	createHelper( final Logging logging )
	{
	    return new StatefulLoggingHelper( logging );
	}
	
	    public void
	testCreate()
	{
	    final Set<Logging>  loggings    = getAllLogging();
	    
	    for( final Logging logging : loggings )
	    {
	        assert( createHelper(logging) != null );
	    }
	}
	
	    private void
	validateResult( final LogQueryResult result )
	{
	    assert( result != null );
	    assert( result.getFieldNames() != null );
	    assert( result.getEntries() != null );
	}
	
	
	    public void
	testQuery()
	{
	    final long  start   = now();
	    
	    final Set<Logging>  loggings    = getAllLogging();
	    
	    for( final Logging logging : loggings )
	    {
	        assert( logging != null );
    	    final StatefulLoggingHelper helper  = createHelper(logging);
    	    
    	    final LogQueryResult    result  = helper.query();
    	    validateResult( result );
	    }
	    
	    printElapsed( "testQuery", start);
	}
	
}





















