/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/config/MailResourceConfigTest.java,v 1.6 2006/03/09 20:30:54 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:54 $
 */
package com.sun.enterprise.management.config;

import java.util.Collections;
import java.util.Map;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.MailResourceConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;



/**
 */
public final class MailResourceConfigTest extends ResourceConfigTestBase
{
    private static final String MAIL_RESOURCE_HOST = "localhost";
    private static final String MAIL_RESOURCE_USER = "someone";
    private static final String MAIL_RESOURCE_FROM = "someone@somewhere.com";

    public MailResourceConfigTest()
    {
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
            ensureDefaultInstance( getDomainConfig() );
        }
    }
    
         public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "MailResourceConfig" );
    }
    
	    public static MailResourceConfig
	ensureDefaultInstance( final DomainConfig dc )
	{
	    MailResourceConfig result = dc.getMailResourceConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createInstance( dc, getDefaultInstanceName(),
	            MAIL_RESOURCE_HOST, MAIL_RESOURCE_USER, MAIL_RESOURCE_FROM, null);
	    }
	    
	    return result;
	}
	
	    public static MailResourceConfig
	createInstance(
	    final DomainConfig ss,
	    final String    name,
	    final String    host,
	    final String    user,
	    final String    from,
	    Map<String,String> optional)
	{
	    return ss.createMailResourceConfig( name, host, user, from, optional );
	}
	
    	protected String
	getProgenyTestName()
	{
		return( "jndi/MailResourceConfigMgrTest" );
	}
	
		protected Container
	getProgenyContainer()
	{
		return getDomainConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.MAIL_RESOURCE_CONFIG;
	}


		protected void
	removeProgeny( final String name )
	{
		getDomainConfig().removeMailResourceConfig( name );
	}
    
		protected final AMXConfig
	createProgeny( final String name, final Map<String,String> options )
	{
	    final MailResourceConfig	config	=
	    	getDomainConfig().createMailResourceConfig( name,
	                                MAIL_RESOURCE_HOST,
	                                MAIL_RESOURCE_USER,
	                                MAIL_RESOURCE_FROM,
	                                options);
		assert( config != null );
		return( config );
	}
	
}


