/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.HashSet;
import java.util.HashMap;

import javax.management.ObjectName;
import javax.management.JMException;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.LifecycleModuleConfig;

import com.sun.appserv.management.helper.RefHelper;

import com.sun.enterprise.management.support.AMXLifecycleModule;

/**
 */
public final class LifecycleModuleConfigTest extends AMXTestBase
{
    // built-into server already
    private static final String IMPL_CLASSNAME = AMXLifecycleModule.class.getName();
        
    private static final String TEST_NAME_BASE = "custom";
    private static final String TEST_TYPE      = "CustomMBeanConfigTest";
    
		public
	LifecycleModuleConfigTest ()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainConfig() );
	    }
	}
	
	   public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "LifecycleModuleConfig" );
    }
    
        public static LifecycleModuleConfig
	ensureDefaultInstance( final DomainConfig domainConfig )
	{
	    LifecycleModuleConfig   result  =
	        domainConfig.getLifecycleModuleConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createInstance( 
	            domainConfig,
	            getDefaultInstanceName(),
	            IMPL_CLASSNAME,
	            1 );
	    }
	    
	    return result;
	}
	
		public static LifecycleModuleConfig
	createInstance(
	    final DomainConfig          domainConfig,
	    final String                name,
	    final String                classname,
	    final int                   loadOrder )
	{
	    final boolean  isFailureFatal = false;
	    final boolean  enabled = true;
	    final String   classpath = "/test";
	    final String   description = null;
	    
	    final LifecycleModuleConfig life    =
	    	domainConfig.createLifecycleModuleConfig(  name,
	    	                    description,
	                            classname,
	                            classpath, 
	                            "" + loadOrder,
	                            isFailureFatal,
	                            enabled,
	                            null );
	    
	    return life;
	}
	
	
		public Map<String,LifecycleModuleConfig>
	getLifecycleModuleConfigs()
	{
	    return getDomainConfig().getLifecycleModuleConfigMap();
	}
	
		private void
	_testGetAll()
	{
	    
	    final Map<String,LifecycleModuleConfig> all = getLifecycleModuleConfigs();
		assert( all != null );
	}
	
	    private void
	sanityCheck( final LifecycleModuleConfig config )
	{
        config.setClassname( config.getClassname() );
        
        final String    classpath = config.getClasspath();
        config.setClasspath( classpath == null ? "" : classpath );
        
        config.setLoadOrder( config.getLoadOrder() );
        
        config.setIsFailureFatal( config.getIsFailureFatal() );
        
        config.setEnabled( config.getEnabled() );
	}

		public synchronized void
	testAttrs()
	{
	    ensureDefaultInstance( getDomainConfig() );
	    
	    final Map<String,LifecycleModuleConfig> all = getLifecycleModuleConfigs();
	    
	    if ( all.size() != 0 )
	    {
    	    for( final LifecycleModuleConfig config : all.values() )
    	    {
    	        sanityCheck( config );
    	    }
	    }
	    else
	    {
	        warning( "LifecycleModuleConfigTest: No LifecycleModuleConfig to test" );
	    }
	}
	
		public synchronized void
	testCreateRemove()
	{
	    final DomainConfig  domainConfig    = getDomainConfig();
	    
	}
}






































