/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.HashSet;
import java.util.Arrays;

import javax.management.ObjectName;

import com.sun.appserv.management.config.JavaConfig;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class JavaConfigTest extends AMXTestBase
{
		public
	JavaConfigTest ()
	{
	}

		public void
	testGetJVMOptions()
	{
	    final JavaConfig    jc  = getConfigConfig().getJavaConfig();
	    
	    final String[]  jvmOptions  = jc.getJVMOptions();
	    
	    if ( jvmOptions.length < 2 )
	    {
	        warning( "Fewer than 2 JVM options, is this right: " +
	            StringUtil.toString( jvmOptions ));
	        
	    }
	    
	    /*
	    Arrays.sort( jvmOptions );
        trace("length = " + jvmOptions.length);
        for (int ii=0; ii<jvmOptions.length; ii++)
        {
            trace("jvmOptions[" + ii + "] = " + jvmOptions[ii]);
        }
        */
	}
	
	    public void
	testSetJVMOptions()
	{
	    final String    newOption1  = "-DJavaConfigTest.OK=true";
	    final String    newOption2  = "-XJavaConfigTest.OK=true";
	    
	    final JavaConfig    jc  = getConfigConfig().getJavaConfig();
	    
	    final Set<String>  beforeSet  = GSetUtil.newUnmodifiableStringSet( jc.getJVMOptions() );
	    
	    // add our new options
	    final Set<String>   requestSet  = new HashSet<String>( beforeSet );
	    requestSet.add( newOption1 );
	    requestSet.add( newOption2 );
	    jc.setJVMOptions( GSetUtil.toStringArray( requestSet ) );

	    Set<String>  afterSet  = GSetUtil.newUnmodifiableStringSet( jc.getJVMOptions() );
	    
	    // make sure our new options are present
	    assert( afterSet.contains( newOption1 ) );
	    assert( afterSet.contains( newOption2 ) );
	    
	    // make sure all prior options are still present
	    for( final String beforeOption : beforeSet )
	    {
	        assert( afterSet.contains( beforeOption ) );
	    }
	    
	    // now remove our two options
	    requestSet.remove( newOption1 );
	    requestSet.remove( newOption2 );
	    jc.setJVMOptions( GSetUtil.toStringArray( requestSet ) );
	    
	    // verify our two options are gone
	    afterSet  = GSetUtil.newUnmodifiableStringSet( jc.getJVMOptions() );
	    assert( ! afterSet.contains( newOption1 ) );
	    assert( ! afterSet.contains( newOption2 ) );
	    
	    // make sure all prior options are still present
	    assert( afterSet.equals( beforeSet ) );
	}
	
		public void
	testGetters()
		throws Exception
	{
	    final JavaConfig    jc  = getConfigConfig().getJavaConfig();
	    
	    String  s;
	    
    	s   = jc.getBytecodePreprocessors();
    	if ( s != null )
    	{
    	    jc.setBytecodePreprocessors( s );
    	}

    	s   = jc.getClasspathPrefix();
    	if ( s != null )
    	{
    	    jc.setClasspathPrefix( s );
    	}

    	s   = jc.getClasspathSuffix();
    	if ( s != null )
    	{
    	    jc.setClasspathSuffix( s );
    	}

    	s   = jc.getSystemClasspath();
    	if ( s != null )
    	{
    	    jc.setSystemClasspath( s );
    	}

    	final boolean debugEnabled =	jc.getDebugEnabled();
    	jc.setDebugEnabled( debugEnabled );

    	s   = jc.getDebugOptions();
    	if ( s != null )
    	{
    	    jc.setDebugOptions( s );
    	}

    	final boolean	envClasspathIgnored = jc.getEnvClasspathIgnored();
    	jc.setEnvClasspathIgnored( envClasspathIgnored );

    	s   = jc.getJavaHome();
    	if ( s != null )
    	{
    	    jc.setJavaHome( s );
    	}

    	s   = jc.getJavacOptions();
    	if ( s != null )
    	{
    	    jc.setJavacOptions( s );
    	}

    	final String[]	options = jc.getJVMOptions();
    	if ( options != null )
    	{
    	    jc.setJVMOptions( options );
    	}

    	s   = jc.getNativeLibraryPathPrefix();
    	if ( s != null )
    	{
    	    jc.setNativeLibraryPathPrefix( s );
    	}

    	s   = jc.getNativeLibraryPathSuffix();
    	if ( s != null )
    	{
    	    jc.setNativeLibraryPathSuffix( s );
    	}

    	s   = jc.getRMICOptions();
    	if ( s != null )
    	{
    	    jc.setRMICOptions( s );
    	}

    	s   = jc.getServerClasspath();
    	if ( s != null )
    	{
    	    jc.setServerClasspath( s );
    	}
	}
}

















