/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/config/JDBCConnectionPoolConfigTest.java,v 1.5 2006/03/09 20:30:54 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:54 $
 */
package com.sun.enterprise.management.config;

import java.util.Collections;
import java.util.Map;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.JDBCConnectionPoolConfig;

/**
 */
public final class JDBCConnectionPoolConfigTest extends ConfigMgrTestBase
{
    private static final String JDBC_DATASOURCE_CLASSNAME = "com.pointbase.xa.xaDataSource";


    public JDBCConnectionPoolConfigTest()
    {
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
            ensureDefaultInstance( getDomainConfig() );
        }
    }
    
          public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "JDBCConnectionPoolConfig" );
    }
    
         public static JDBCConnectionPoolConfig
	ensureDefaultInstance( final DomainConfig domainConfig )
	{
	    JDBCConnectionPoolConfig   result  =
	        domainConfig.getJDBCConnectionPoolConfigMap().get(
	            getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createInstance( domainConfig,
	            getDefaultInstanceName(), JDBC_DATASOURCE_CLASSNAME, null );
	    }
	    
	    return result;
	}
	
	    public static JDBCConnectionPoolConfig
	createInstance(
	    final DomainConfig  domainConfig,
	    final String        name,
	    final String        datasourceClassname,
	    final Map<String,String> optional )
	{
	    return  domainConfig.createJDBCConnectionPoolConfig(
	            name, datasourceClassname, optional );
	}
	
	
    	protected Container
	getProgenyContainer()
	{
		return getDomainConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.JDBC_CONNECTION_POOL_CONFIG;
	}


		protected void
	removeProgeny( final String name )
	{
		getDomainConfig().removeJDBCConnectionPoolConfig( name );
	}
	
		protected final AMXConfig
	createProgeny(String name, Map<String,String> options )
	{
	    final JDBCConnectionPoolConfig	config	=
	    	getDomainConfig().createJDBCConnectionPoolConfig( name,
				JDBC_DATASOURCE_CLASSNAME,
				options );
		assert( config != null );
		return( config );
	}
}


