/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;

import javax.management.ObjectName;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.base.SystemInfo;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.ConfigConfig;

import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.StringUtil;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;
import com.sun.enterprise.management.MultipleServerSupportRequired;


/**
 */
public final class ConfigConfigTest extends AMXTestBase
    implements MultipleServerSupportRequired
{
		public
	ConfigConfigTest()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainRoot() );
	    }

	}
    
        public static ConfigConfig
	ensureDefaultInstance( final DomainRoot domainRoot )
	{
        ConfigConfig   config   = null;
        
        final DomainConfig  domainConfig    = domainRoot.getDomainConfig();
        final Map<String,ConfigConfig>  existing  = domainConfig.getConfigConfigMap();
        
        if ( supportsMultipleServers( domainRoot ) )
        {
            config = existing.get( getDefaultInstanceName( domainRoot ) );
            if ( config == null )
            {
                final ConfigSetup setup  = new ConfigSetup( domainRoot );
                config  = setup.createConfig( getDefaultInstanceName( domainRoot ) );
            }
        }
        else
        {
            config = existing.get( PE_CONFIG_NAME );
            assert( config != null ) : "No config named " + StringUtil.quote( PE_CONFIG_NAME );
        }
        return config;
	}

        public static String
    getDefaultInstanceName( final DomainRoot domainRoot )
    {
        String  name    = null;
        
        if ( domainRoot.getSystemInfo().supportsFeature( SystemInfo.MULTIPLE_SERVERS_FEATURE ) )
        {
            name    = getDefaultInstanceName( "ConfigConfigTest" );
        }
        else
        {
            name = PE_CONFIG_NAME;
        }
        return name;
    }

	
	   private ConfigConfig
	create( final String name )
	    throws Throwable
	{
        final ConfigSetup setup  = new ConfigSetup( getDomainRoot() );
        
        setup.removeConfig( name );
        
        final ConfigConfig  config  = setup.createConfig( name );
        assert( name.equals( config.getName() ) );
        
        // see that it responds to a request
        final Map<String,Object>    attrs   = Util.getExtra( config ).getAllAttributes();
        //printVerbose( "Attributes for config " + config.getName() + ":" );
        //printVerbose( MapUtil.toString( attrs, NEWLINE ) );
    
        return config;
	}
	
	    public void
	testCreateRemove()
	    throws Throwable
	{
	    if ( ! checkNotOffline( "testCreateRemove" ) )
	    {
	        return;
	    }
	    
        final String NAME    = "ConfigConfigTest.testCreateRemove";
        
        final Map<String,ConfigConfig>  before  = getDomainConfig().getConfigConfigMap();
        
        final int   NUM = 2;
        final ConfigConfig[]    configs = new ConfigConfig[ NUM ];
        
        for( int i = 0; i < NUM; ++i )
        {
	        configs[ i ]    = create( NAME + i );
	    }
	    
        final ConfigSetup setup  = new ConfigSetup( getDomainRoot() );
        for( final ConfigConfig config : configs )
        {
            setup.removeConfig( config.getName() );
            
            // verify that the config is gone
            try
            {
                Util.getExtra( config ).getAllAttributes();
                fail( "Config " + config.getName() + " should no longer exist" );
            }
            catch( Exception e )
            {
                // good, we expected to be here
            }
	    }
	    
        final Map<String,ConfigConfig>  after  = getDomainConfig().getConfigConfigMap();
        assert( before.keySet().equals( after.keySet() ) );
    }
}



























