/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
package com.sun.enterprise.management.support;

import javax.management.MBeanServer;
import javax.management.ObjectName;

import java.io.File;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.FileUtils;

import com.sun.enterprise.management.support.BootUtil;


/**
 */
public final class AMXDebugSupport
    implements AMXDebugSupportMBean
{
    private final MBeanServer   mServer;
    
    public static final String  NAME    = "amx-debug";
    
        public
    AMXDebugSupport( final MBeanServer server )
    {
        mServer = server;
        
        final String    domain  =
            BootUtil.getInstance().getAMXSupportJMXDomain();
        
        final String    props   = Util.makeNameProp( NAME);
        
        final ObjectName    objectName  = Util.newObjectName( domain, props );
        try
        {
            mServer.registerMBean( this, objectName );
        }
        catch( Exception e )
        {
            throw new RuntimeException( e );
        }
    }
    
        private AMXDebug
    getAMXDebug()
    {
        return AMXDebug.getInstance();
    }
    
        public String[]
    getOutputIDs()
    {
        return AMXDebug.getInstance().getOutputIDs();
    }
    
        public boolean
    getDefaultDebug()
    {
        return getAMXDebug().getDefaultDebug();
    }
     
        public void
    setDefaultDebug( boolean debug )
    {
        getAMXDebug().setDefaultDebug( debug );
    } 
    
        public boolean
    getDebug( final String id )
    {
        return getAMXDebug().getDebug( id );
    }
    
        public void
    setDebug( final String id, final boolean debug )
    {
        getAMXDebug().setDebug( id, debug );
    } 
    
        public void
    setAll( final boolean debug )
    {
        getAMXDebug().setAll( debug );
    }
    
        public void
    cleanup()
    {
        getAMXDebug().cleanup();
    }
    
        public String
    getOutputFrom( final String id )
    {
        String  output  = "";
        
        final File  f   = getAMXDebug().getOutputFile( id );
        if ( f != null && f.exists() )
        {
            try
            {
                output  = FileUtils.fileToString( f );
            }
            catch( Exception e )
            {
                output  = "";
            }
        }
        
        return output;
    }
}

























