/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.management.deploy;

import java.util.Map;
import java.io.Serializable;

import com.sun.appserv.management.util.misc.TypeCast;

import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentStatusImpl;

import com.sun.enterprise.deployment.phasing.DeploymentService;
import com.sun.enterprise.deployment.backend.DeploymentRequestRegistry;


final class Undeployer
{
    private final String mModuleID;
    private Map mParams;

    public Undeployer(final String moduleID, final Map<String,String> params) {
        mModuleID = moduleID;
        mParams = params;
    }
	
    public DeploymentStatus undeploy()
    {
        try
        {
            com.sun.enterprise.deployment.backend.DeploymentStatus ds =
                DeploymentService.getDeploymentService().undeploy(mModuleID, mParams);
                
            ds.setStageStatus(ds.getStatus()); // This is done for the AMX clients to get complete status

            DeploymentRequestRegistry.getRegistry().removeDeploymentRequest( mModuleID);

            final Map<String,Serializable>  m =
                TypeCast.checkMap( ds.asMap(), String.class, Serializable.class );
                
            return new DeploymentStatusImpl( m );
        }
        
        catch(Exception e)
        {
            com.sun.enterprise.deployment.backend.DeploymentStatus ds =
                new com.sun.enterprise.deployment.backend.DeploymentStatus();
            ds.setStageException(e);
            ds.setStageStatus(com.sun.enterprise.deployment.backend.DeploymentStatus.FAILURE);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("UnDeployment");
            DeploymentRequestRegistry.getRegistry().removeDeploymentRequest(
                mModuleID);
                
            final Map<String,Serializable>  m =
                TypeCast.checkMap( ds.asMap(), String.class, Serializable.class );
                
            return new DeploymentStatusImpl( m );
        }
    }           
}

