/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/JMXConnectorConfigFactory.java,v 1.6 2006/03/09 20:30:39 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:39 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;


import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.config.JMXConnectorConfigKeys;
import com.sun.appserv.management.config.JMXConnectorConfigKeys;

import com.sun.enterprise.management.support.oldconfig.OldAdminServiceMBean;


import com.sun.appserv.management.util.misc.GSetUtil;

/**
 */
public final class JMXConnectorConfigFactory extends ConfigFactory
{
	private final OldAdminServiceMBean	mOldAdminServiceMBean;
	
		public 
	JMXConnectorConfigFactory(
		final ConfigFactoryCallback callbacks) 
	{
		super( callbacks );
		
		mOldAdminServiceMBean	= getOldAdminServiceMBean();
	}
	
	
		private final OldAdminServiceMBean
	getOldAdminServiceMBean()
	{
		return( getOldConfigProxies().getOldAdminServiceMBean( getConfigName() ) );
	}
	
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		    JMXConnectorConfigKeys.ACCEPT_ALL_KEY,
		    JMXConnectorConfigKeys.SECURITY_ENABLED_KEY );
    	protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	private static final String	ADDRESS_KEY				= "Address";
	private static final String	PORT_KEY				= "Port";
	private static final String	AUTH_REALM_NAME_KEY		= "AuthRealmName";
	
	
	
		public ObjectName	
	create( String name, String address, String port, 
		String authRealmName, Map<String,String> optional )
	{
		final String[] requiredParams = 
		{
			ADDRESS_KEY,				address,
			PORT_KEY,					port,
			AUTH_REALM_NAME_KEY,		authRealmName,
		};
		final Map<String,String> params = initParams( name, requiredParams, optional );
		final ObjectName amxObjectName = createNamedChild( name, params );
		return amxObjectName;
	}

		protected void	
	removeByName( final String name )
	{
		mOldAdminServiceMBean.removeJmxConnectorByName( name );
	}

		protected ObjectName
	createOldChildConfig( final AttributeList translatedAttrs )
	{
		return mOldAdminServiceMBean.createJmxConnector( translatedAttrs );
	}
}




