/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ZipStorage.java
 *
 * Created on January 30, 2004, 7:15 PM
 */

package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.util.FileListerRelative;
import com.sun.enterprise.config.backup.util.FileUtils;
import com.sun.enterprise.config.backup.util.ZipFileException;
import com.sun.enterprise.config.backup.util.ZipWriter;
import java.io.*;

/** 
 * This class implements storing backups as zip files.  
 * @author Byron Nevins
 */
class ZipStorage
{
	/**
	 * @param req
	 * @throws BackupException
	 */	
	ZipStorage(BackupRequest req) throws BackupException
	{
		if(req == null)
			throw new BackupException("backup-res.NoBackupRequest", getClass().getName() + ".ctor");
		
		request = req;
	}
	
	/** 
	 * Backups the files to a zip file.  
	 * @throws BackupException if there were any errors writing the file.
	 */	
	void store() throws BackupException
	{
		String zipName			= FileUtils.safeGetCanonicalPath(request.backupFile);
		String domainDirName	= FileUtils.safeGetCanonicalPath(request.domainDir);
		
		FileListerRelative lister = new FileListerRelative(request.domainDir);
		lister.keepEmptyDirectories();	// we want to restore any empty directories too!
		String[] files = lister.getFiles();
		
		LoggerHelper.fine("Writing " + zipName);
		
		try
		{
			ZipWriter writer = new ZipWriter(zipName, domainDirName, files);

			if(request.excludeDirs != null && request.excludeDirs.length > 0)
				writer.excludeDirs(request.excludeDirs);
			
			writer.safeWrite();
		}
		catch(ZipFileException zfe)
		{
			throw new BackupException("backup-res.ZipBackupError", zfe, zipName);
		}
	}

	///////////////////////////////////////////////////////////////////////////

	void write() throws BackupException
	{
		
	}

	///////////////////////////////////////////////////////////////////////////
	
	private	BackupRequest request;
}
