/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ZipFilenameFilter.java
 *
 * Created on March 30, 2004, 9:40 PM
 */

package com.sun.enterprise.config.backup;

import java.io.*;

/**
 *
 * @author  bnevins
 * Tiny class.  It is here because it is used in 2 places --
 * RestoreManager and ListManager and it avoids code duplication.
 */

class ZipFilenameFilter implements FilenameFilter
{
	public boolean accept(File dir, String name)
	{
		return 
			name.toLowerCase().endsWith(".zip") && 
			name.startsWith(Constants.BACKUP_FILENAME_ROOT);
	}
}
