/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * BasicTree.java
 *
 * Created on April 7, 2004, 10:44 PM
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import java.util.ArrayList;

//import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.iplanet.jato.RequestContext;


/**
 *
 * @author  anissa
 *
 */
public interface BasicTree {
    
    // This method is called after the constructor of the implementing class for any initialization.
    public void init(ViewDescriptor viewDescriptor, RequestContext ctx);
    
    //This method should return the root of the tree.
    public Object getRoot();
    
    //Given the parent, this should return an ArrayList of all its children.
    //The ArrayList should be empty if no child exist.
    public ArrayList getChildren(Object parent);
    
    //Given the node, return if is is a child node.
    public boolean hasChildren (Object node);
    
    //This method is called to get the display name of the node on the tree. 
    //The parameter passed is one of the nodes in the ArrayList returned by getChildren
    public String getDisplayName(Object node);
    
    public String getURL();
    public String getKey(Object node);
}
