/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view;

import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View; 
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;

import com.sun.enterprise.tools.guiframework.exception.ChildNotRegisteredException;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.table.CCActionTable;


public class DescriptorCCActionTableTiledView extends DescriptorTiledView {

    /**
     *	Constructor
     */
    public DescriptorCCActionTableTiledView(RequestContext ctx, ContainerView container, String name, ViewDescriptor desc, Model model) {
	super(ctx, container, name, desc);
	setDefaultModel(model); // This will be used for PrimaryModel also
    }


    /**
     *	This method is defined in ContainerView, but it is important to
     *	to override this.
     *
     *	This method should delegate to the helper createChild method to use the
     *	descriptor information
     */
    public View createChild(String name) {
	View child = null;
	try {
	    // Try to create the Child via a child descriptor
	    child = DescriptorViewHelper.createChild(this, name);
	} catch (ChildNotRegisteredException ex) {
	    // Some children have built-in support via CCActionTable
	    View parent = getParent();
	    while ((parent != null) && !(parent instanceof CCActionTable)) {
		parent = parent.getParent();
	    }
	    if (parent == null) {
		throw new FrameworkException("Unable to create child '"+name+
		    "'.", ex, getViewDescriptor().getChildDescriptor(name), this);
	    }
	    child = ((ContainerView)parent).getChild(name);
	}

	// return the child
	return child;
    }


    ////////////////////////////////////////////////////////////
    //                    Event Methods                       //
    ////////////////////////////////////////////////////////////

    /**
     *
     */
    public boolean beginChildDisplay(ChildDisplayEvent event) throws ModelControlException {
	if (getViewDescriptor().getChildDescriptor(event.getChildName()) == null) {
	    // This means that an event was called expecting the child to be
	    // under this tiled view, but it is possible that it may be
	    // directly in the parent.  This is because fields like href's may
	    // choose to not be indexed, but may appear in the tiled view.
	    return DescriptorViewHelper.beginChildDisplay(
		((DescriptorContainerView)getParent()), event);
	}
	return DescriptorViewHelper.beginChildDisplay(this, event);
    }


    /**
     *
     */
    public String endChildDisplay(ChildContentDisplayEvent event) throws ModelControlException {
	if (getViewDescriptor().getChildDescriptor(event.getChildName()) == null) {
	    // This means that an event was called expecting the child to be
	    // under this tiled view, but it is possible that it may be
	    // directly in the parent.  This is because fields like href's may
	    // choose to not be indexed, but may appear in the tiled view.
	    return DescriptorViewHelper.endChildDisplay(
		((DescriptorContainerView)getParent()), event);
	}
	return DescriptorViewHelper.endChildDisplay(this, event);
    }
}
