/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.util;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 *  This class provides helper methods for logging messages on from within this
 *  framework.  These utility methods are meant for internal framework use.
 */
public class LogUtil {

    /**
     *	This helper method logs a framework message at the given log level.
     *
     *	<UL>
     *	<LI>FINEST indicates a highly detailed tracing message.
     *	<LI>FINER indicates a fairly detailed tracing message.
     *	<LI>FINE is a message level providing tracing information.
     *	<LI>CONFIG is a message level for static configuration messages.
     *	<LI>INFO is a message level for informational messages.
     *	<LI>WARNING is a message level indicating a potential problem.
     *	<LI>SEVERE is a message level indicating a serious failure.
     *	</UL>
     */
    public static void log(Level level, String msg, Object[] params) {
	_logger.log(level, msg, params);
    }


    /**
     *
     */
    public static void log(Level level, String msg, Object param1) {
	_logger.log(level, msg, param1);
    }


    /**
     *
     */
    public static void log(Level level, String msg) {
	_logger.log(level, msg);
    }


    /**
     *
     */
    public static void log(Level level, String msg, Throwable thrown) {
	_logger.log(level, msg, thrown);
    }


    /**
     *	This method is sets to the log Levels which will be logged.  Any Level
     *	more severe than the given level will be logged.
     *
     *	<UL>
     *	<LI>FINEST indicates a highly detailed tracing message.
     *	<LI>FINER indicates a fairly detailed tracing message.
     *	<LI>FINE is a message level providing tracing information.
     *	<LI>CONFIG is a message level for static configuration messages.
     *	<LI>INFO is a message level for informational messages.
     *	<LI>WARNING is a message level indicating a potential problem.
     *	<LI>SEVERE is a message level indicating a serious failure.
     *	</UL>
     */
    public static void setLevel(Level level) {
	_logger.setLevel(level);
    }


    /**
     *	This method is used to determine if the given log Level will be logged.
     */
    public static boolean isLoggable(Level level) {
	return _logger.isLoggable(level);
    }


    /** 
     *	This is the Framework logger name
     */
    public static final String	FRAMEWORK_LOGGER_NAME =
	"com.sun.enterprise.tools.guiframework";

    /** 
     *	This is the bundle name
     */
    public static final String	BUNDLE_NAME =
	"LogStrings";

    /**
     *	This is the Logger to use for Framework log messages
     */
    public  static final Logger _logger = Logger.getLogger(
	FRAMEWORK_LOGGER_NAME, FRAMEWORK_LOGGER_NAME+"."+BUNDLE_NAME);
    
    public static Level stringToLogLevel(String level) {
        if (level == null)
            return Level.INFO;
        if (level.equalsIgnoreCase("FINEST"))
            return Level.FINEST;
        if (level.equalsIgnoreCase("FINER"))
            return Level.FINER;
        if (level.equalsIgnoreCase("FINE"))
            return Level.FINE;
        if (level.equalsIgnoreCase("CONFIG"))
            return Level.CONFIG;
        if (level.equalsIgnoreCase("INFO"))
            return Level.INFO;
        if (level.equalsIgnoreCase("WARNING"))
            return Level.WARNING;
        if (level.equalsIgnoreCase("SEVERE"))
            return Level.SEVERE;
        return Level.INFO;
    }
    

    /**
     *	The following constants are for the convience of specifying the
     *	equivalent Level constants.
     */
    public static final Level	FINEST =	Level.FINEST;
    public static final Level	FINER =		Level.FINER;
    public static final Level	FINE =		Level.FINE;
    public static final Level	CONFIG =	Level.CONFIG;
    public static final Level	INFO =		Level.INFO;
    public static final Level	WARNING =	Level.WARNING;
    public static final Level	SEVERE =	Level.SEVERE;
}
