/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

// This function will get the cookie value.
function ccGetCookie() {
    // Get document cookie.
    var cookie = document.cookie;

    // Parse ccScrollCookie value.
    var pos = cookie.indexOf(this.$cookieName + "=");

    if (pos == -1)
        return null;

    var start = pos + this.$cookieName.length + 1;

    var end = cookie.indexOf(";", start);

    if (end == -1)
        end = cookie.length;

    // return cookie value
    return cookie.substring(start, end);
}

// This function will load the cookie value.
function ccLoadCookie() {
    // Get document cookie.
    var cookieVal = this.get();

    if (cookieVal == null)
        return false;

    // Break cookie into names and values.
    var a = cookieVal.split('&');

    // Break each pair into an array.
    for (var i = 0; i < a.length; i++) {
        a[i] = a[i].split(':');
    }

    // Set name and values for this object.
    for (var i = 0; i < a.length; i++) {
        this[a[i][0]] = unescape(a[i][1]);
    }

    return true;
}

// This function will reset the cookie value.
function ccResetCookie() {
    // Clear cookie value.
    document.cookie = this.$cookieName + "=";

    return true;
}

// This function will display the cookie value.
function ccShowCookie() {
    alert(this.$cookieName + " = " + this.get());
    return true;
}

// This function will store the cookie value.
function ccStoreCookie() {
    // Create cookie value by looping through object properties
    var cookieVal = "";

    // Since cookies use the equals and semicolon signs as separators,
    // we'll use colons and ampersands for each variable we store.
    for (var prop in this) {
        // Ignore properties that begin with '$' and methods.
        if (prop.charAt(0) == '$' || typeof this[prop] == 'function')
            continue;
        
        if (cookieVal != "")
            cookieVal += '&';
        
        cookieVal += prop + ':' + escape(this[prop]);
    }

    var cookieString = this.$cookieName + "=" + cookieVal;

    if (this.$path != null) {
        cookieString += ";path=" + this.$path;
    }
    // Store cookie value.
    document.cookie = cookieString;

    return true;
}

//-->
