/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.tree;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.ModelManager;
import com.iplanet.jato.model.TreeModelBase;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ValidationException;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import java.io.Serializable;

public class IndexTreeModelImpl extends TreeModelBaseImpl implements IndexTreeModel,Serializable {
    
    private static final String STATE_DATA_NAME = "IndexTreeStateData";

    public static IndexTreeModel getIndexTreeModel(RequestContext rc) {
	ModelManager mm = (ModelManager)rc.getModelManager();
	IndexTreeModelImpl model = (IndexTreeModelImpl)
                mm.getModel(IndexTreeModelImpl.class,
                mm.getDefaultModelInstanceName(IndexTreeModelImpl.class), 
                true, true);
        
	return model;
    }
    
    public IndexTreeModelImpl() {
	super(ConfigProperties.getInstance().getTreeXMLFileName("index"), 
              STATE_DATA_NAME);
	createIndexData();
    }
}
