/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.taglib;

import java.io.*;
import java.lang.reflect.*;
import java.util.*;
import java.text.NumberFormat;

import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

import org.w3c.dom.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

import com.iplanet.jato.*;
import com.iplanet.jato.model.*;
import com.iplanet.jato.taglib.*;
import com.iplanet.jato.taglib.html.FormTag;
import com.iplanet.jato.util.*;
import com.iplanet.jato.view.*;
import com.iplanet.jato.view.event.*;
import com.iplanet.jato.view.html.*;

import com.sun.web.ui.common.*;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.taglib.propertysheet.CCPropertySheetTag;
import com.sun.web.ui.view.html.*;
import com.sun.web.ui.view.propertysheet.*;
import com.sun.web.ui.taglib.common.*;
import com.sun.web.ui.taglib.html.*;
import com.sun.web.ui.taglib.help.*;
import com.sun.web.ui.taglib.spacer.*;

import com.sun.enterprise.tools.admingui.util.Util;

public class DataSheetTag extends CCPropertySheetTag {

    // ASPropertySheet addition
    private int iCurrentSection = 0;
    private ArrayList dataObjects = null;
    private static final String DATA_ELEMENT = "dataValue";
    private static final String TEMPLATE_ELEMENT = "sectionTemplate";
    
    // ASPropertySheet addition
    private class MyNodeList extends ArrayList implements NodeList {
        public Node item(int i) {
            return (Node)super.get(i);
        }
        public int getLength() {
            return super.size();
        }
    }

    /**
     * Default constructor
     */
    public DataSheetTag() {
	super();
    }

    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Tag handler methods
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * Reset cached state to allow for a new rendering of this tag instance.
     * Note that this method only resets class data members; it does not reset
     * tag attribute values.
     */
    public void reset() {
	super.reset();
        
        // ASPropertySheet addition
        dataObjects = null;
    }

    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Micro component methods
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * Generate the HTML for the Property Sheet and return the HTML as a 
     * String.
     *
     * The code in this method is separated out from the getHTMLString method 
     * in order to prevent reset() from being called by subclasses. Subclasses
     * should call
     * <code>super.getHTMLStringInternal(Tag, PageContext, View)</code> from
     * their getHTMLStringInternal method.
     *
     * @param parent The Tag instance enclosing this tag.
     * @param pageContext The page context used for this tag.
     * @param view The container view used for this tag.
     * @return The HTML string for the property sheet.
     */
    protected String getHTMLStringInternal(Tag parent, PageContext pageContext,
	    View view) throws JspException {
	if (parent == null) {
	    throw new IllegalArgumentException("parent cannot be null.");
	} else if (pageContext == null) {
	    throw new IllegalArgumentException("pageContext cannot be null.");
	} else if (view == null) {
	    throw new IllegalArgumentException("view cannot be null.");
	}

	checkChildType(view, CCPropertySheet.class);
	CCPropertySheet field = (CCPropertySheet) view;
	containerView = (field.getContainerView() != null)
	    ? field.getContainerView()
	    : (ContainerView) field.getParent();

        // assign a class variable.
	CCPropertySheetModelInterface model = field.getModel();
	if (model == null) {
	    throw new IllegalArgumentException(
		"PropertySheet model cannot be null");
	}
	if (model.getDocument() == null) {
	    throw new RuntimeException(
		"The property sheet model getDocument() returned null.\n" +
		"Be sure a valid XML file was supplied " +
		"to the property sheet model.");
	}

	// Initialize tag parameters.
	setParent(parent);
	setPageContext(pageContext);

	// set the attributes from the child view.
	if (field.getShowJumpLinks() != null) {
	    setShowJumpLinks(field.getShowJumpLinks().toString());
        }
	NonSyncStringBuffer buffer = new NonSyncStringBuffer(
	    DEFAULT_BUFFER_SIZE);

	// Invoke the begin display event for the child component.
	try {
	    field.beginDisplay(new JspDisplayEvent(this, pageContext));
	} catch (ModelControlException e) {
	    throw new JspException(e.getRootCause());
	}
        numberOfSections = 0;
        // create the HTML for the property sheet.
        appendSections(buffer, getSections(model), model);
        // ASPropertySheet addition
        appendData(buffer, getTemplates(model), model);
        
        // add JavaScript for client side required field checking.
        appendJavaScript(buffer);
        
	return buffer.toString();
    }

    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Higher Level Tag Processing methods.
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    // ASPropertySheet addition
    private Node findMatchingTemplate(NodeList templates, Object data) {
        for (int i=0; i<templates.getLength(); i++) {
            Node template = templates.item(i);
            String cls = this.getAttributeValue(template, "class", null);
            if (cls != null) {
                try {
                    Class clazz = Class.forName(cls);
                    if (clazz.isInstance(data)) {
                        //System.out.println("isInstance of "+cls);
                        return template;
                    }
                } catch (Exception ex) {
                    if (Util.isLoggableINFO()) 
                        Util.logINFO("Error in finding class: " + cls +
                            "\n" + ex.getMessage());
                }
            } else {
                if (Util.isLoggableINFO()) 
                    Util.logINFO("XML error: No class specified for section template.");
            }
        }
        return null;
    }
    
    // ASPropertySheet addition
    private NodeList getSectionsForProcessing(NodeList templates, 
            CCPropertySheetModelInterface model) {
                
        Object [] objs = (Object [])model.getValue("DataObjects");
        if (objs == null)
            return null;
        
        dataObjects = new ArrayList();
        MyNodeList sections = new MyNodeList();
        
        for (int i=0; i<objs.length; i++) {           
            Node template = findMatchingTemplate(templates, objs[i]);
            if (template != null) {
                sections.add(template);
                dataObjects.add(objs[i]);
            } else if (Util.isLoggableINFO()) {
                Util.logINFO("Could not find matching template.");
                Util.logINFO("OBJECT CLASS: "+objs[i].getClass().getName());
                try {
                    Util.logINFO("    name: "+evaluate(objs[i], "$getName", null, null));
                    Util.logINFO("    desc: "+evaluate(objs[i], "$getDescription", null, null));
                } catch (Exception ex) {
                    Util.logINFO("error in evaluate: "+ex.getMessage());
                }
            }
        }
        return sections;
    }
    
    // ASPropertySheet addition
    private Object getCurrentData() {
        return dataObjects.get(iCurrentSection);
    }

    // ASPropertySheet addition
    private void appendData(NonSyncStringBuffer buffer, NodeList templates,
	CCPropertySheetModelInterface model) throws JspException {
        
        NodeList sections = getSectionsForProcessing(templates, model);
        if (sections == null || sections.getLength() == 0)
            return;
        appendSections(buffer, sections, model);
    }
    
    protected void appendSections(NonSyncStringBuffer buffer, NodeList sections,
	CCPropertySheetModelInterface model) throws JspException {

	boolean added = (numberOfSections != 0) && (hasJumpLinks() == false);
	numberOfSections = sections.getLength(); // setting a class variable.
        if (numberOfSections == 0)
            return;
        appendJumpLinks(buffer, sections, model);

	for (int i = 0; i < numberOfSections; i++) {
	    Node section = sections.item(i);
	    if (isVisible(section, model) == false) {
		continue;
            }
	    if (added) {
		// don't add a speparator before the first section has been added
		appendSeparator(buffer);
	    }
            iCurrentSection = i; // DataSheet addition
	    appendSection(buffer, section, model);

	    if (hasJumpLinks()) {
		appendBackToTop(buffer);
            } else {
		buffer.append(getSpacerHTMLString("10", "1"));
            }
	    added = true;
	}
    }

    /* BEGIN JSTYLED */
    // jstyle can't handle the escaped quotes (i.e. \") in HTML strings.

    protected void appendProperty(NonSyncStringBuffer buffer,
	Node property, CCPropertySheetModelInterface model, int level)
	throws JspException {

	buffer.append("<tr>\n"); // start off the property row.

	String labelId = null;
        boolean hasNoValueElement = hasNoValueElement(property);
        // When the property does not contain a value (CC) element, then
        // need to treat the label a little differently.
	boolean colspan = isSpan(property) || hasNoValueElement;
	// column span can happen only if there is no label, thus
	// if colspan==true, implies label = null.
	if (colspan == false) {
	    // Process the label element first
	    // and return a label ID for the Value part, if necessary.

	    labelId = appendLabel(buffer, property, model, level);
	}

	// start the value column.
	if (colspan) {
	    buffer.append("<td valign=\"top\" colspan=\"2\">" +
			  "<div class=\"");
	} else {
	    buffer.append("<td valign=\"top\"><div class=\"");
	}
	buffer.append(getDivClass(colspan, level)).append("\">");

	// loop through the rest of the child elements of the property.
	NodeList subNodes = property.getChildNodes();
	for (int i = 0; i < subNodes.getLength(); i++) {
	    Node subNode = subNodes.item(i);
	    String nodeName = subNode.getNodeName();
	    if (nodeName.equalsIgnoreCase(CCDescriptor.CC_ELEMENT)) {
		if (i != 0) {
		    // if two cc elements are next to each other, need to 
		    // add a newline in the html to get the needed spacing
		    buffer.append("\n");
		}
		// If the value (cc element) is a CCActionTableTag, special
		// formating needs to be applied. The Table cannot be placed
		// in the current open <td> because it will lose it ability 
		// to stretch across the page, which it should according to 
		// the HCI-Admin guildelines. 
		boolean isTableTag = isTableTag(subNode, colspan, level);
		// If the table is not at the first level or the colspan
		// is not true, then don't do this special formating, which
		// implies the table won't stretch.
		if (isTableTag) preTableFormat(buffer);
		
		labelId = appendValue(buffer, subNode, labelId,
				      (level > 1 || colspan == false));
		
		// This whole isTableTag code is kind of a hack. However, it's
		// probably not too common to place a table in a property
		// sheet. If there is a table the span should be true and
		// the level should equal one.
		if (isTableTag) postTableFormat(buffer, colspan, level);
		
	    } else if (nodeName.equalsIgnoreCase(
			    CCPropertySheetModelInterface.HELPTEXT_ELEMENT)) {
		appendFieldHelp(buffer, getNameHTML(subNode));
	    } else if (nodeName.equalsIgnoreCase(
			    CCPropertySheetModelInterface.VALUESET_ELEMENT)) {
		appendValueSet(buffer, subNode, model, level + 1);
	    } else if (nodeName.equalsIgnoreCase(
                            CCPropertySheetModelInterface.LABEL_ELEMENT)) {
                if (hasNoValueElement) {
                    String labelHTML = getNameHTML(subNode);
                    String style = (level > 1)
                        ? CCStyle.LABEL_LEVEL_THREE_TEXT
                        : CCStyle.LABEL_LEVEL_TWO_TEXT;
                    buffer.append(getLabelHTMLString(style, null, null, 
                        isError(property, model), isRequired(property), 
                        labelHTML));
                }
            // DataSheet addition
	    } else if (nodeName.equalsIgnoreCase(DATA_ELEMENT)) {
                labelId = appendDataValue(buffer, subNode, labelId, model);
            } else {
		// Handle any #PCDATA
		String html = subNode.getNodeValue();
		if (html != null)
		    buffer.append(html.trim());
	    }
	}
	buffer.append("</div></td></tr>\n"); // end the table column & row.
    }
    
    private final String Milliseconds = Util.getMessage("label.Milliseconds");
    private final String Seconds = Util.getMessage("label.Seconds");
    private final String Minutes = Util.getMessage("label.Minutes");
    private final String Hours = Util.getMessage("label.Hours");
    private final String Days = Util.getMessage("label.Days");
    private final String Weeks = Util.getMessage("label.Weeks");
    
    private class TimeData {
        private long seconds = 0;
        private long minutes = 0;
        private long hours = 0;
        private long days = 0;
        private long weeks = 0;
        
        private static final long oneWeek = 7*24*60*60; // seconds
        private static final long oneDay = 24*60*60; // seconds
        private static final long oneHour = 60*60; // seconds
        private static final long oneMinute = 60; // seconds
        
        public TimeData(long secs) {
            seconds = secs;
            if (seconds >= oneWeek) {
                weeks = (seconds/oneWeek);
                seconds = seconds - weeks*oneWeek;
            }
            if (seconds >= oneDay) {
                days = (seconds/oneDay);
                seconds = seconds - days*oneDay;
            }
            if (seconds >= oneHour) {
                hours = (seconds/oneHour);
                seconds = seconds - hours*oneHour;
            }
            if (seconds >= oneMinute) {
                minutes = (seconds/oneMinute);
                seconds = seconds - minutes*oneMinute;
            }
        }
        
        public String toString() {
            String str = "&nbsp;";
            if (weeks > 0)
                str += weeks + "&nbsp;" + Weeks + ",&nbsp;";
            if (days > 0 || str.length() > 6)
                str += days + "&nbsp;" + Days + ",&nbsp;";
            if (hours > 0 || str.length() > 6)
                str += hours + "&nbsp;" + Hours + ",&nbsp;";
            if (minutes > 0 || str.length() > 6)
                str += minutes + "&nbsp;" + Minutes + ",&nbsp;";
            if (seconds > 0 || str.length() > 6)
                str += seconds + "&nbsp;" + Seconds + "&nbsp;";
            return str;
        }
    }

    private String convert(long value, String unit) {
        if (unit == null || value == 0) 
            return "";
        TimeData t = null;
        // This is not I18N. 
        // If the unit string is not recognized, no conversion is done.
        if (unit.equalsIgnoreCase(Milliseconds)) {
            t = new TimeData((value+500)/1000);
        } else if (unit.equalsIgnoreCase(Seconds)) {
            t = new TimeData(value);
        } else if (unit.equalsIgnoreCase(Minutes)) {
            t = new TimeData(value*60);
        } else {
            return "";
        }
        return "  (" + t.toString() + ")";
    }

    // DataSheet addition
    private long getLongValue(Object value) {
        if (value instanceof Long)
            return ((Long)value).longValue();
        else if (value instanceof Integer)
            return ((Integer)value).longValue();
        else
            return new Long((String)value.toString()).longValue();
    }

    // DataSheet addition
    private String evaluate(Object data, String methodName, 
            String formatType, String unit) throws Exception {
        if (methodName.indexOf('$') == 0) {
            methodName = methodName.substring(1);
        } else {
            throw new RuntimeException("Method Names must begin with a '$': " + 
                methodName);
        }
	Method method = null;
	try {
	    method = data.getClass().getMethod(methodName, (Class[])null);
	} catch (NoSuchMethodException ex) {
	    throw new RuntimeException("Method '" + methodName + 
                "' not found!", ex);
	}
        Object value = method.invoke(data, (Object[])null);
        if (formatType ==  null || formatType.equalsIgnoreCase("String")) {
            return value.toString();
        } else if (formatType.equalsIgnoreCase("Date")) {
            Date date = new Date(getLongValue(value));
            return date.toString();
        } else if (formatType.equalsIgnoreCase("Number")) {
            long longValue = getLongValue(value);
            String html = NumberFormat.getInstance().format(longValue);
            if (unit == null) 
                return html;
            return html + "&nbsp;" + Util.getMessage(unit) + convert(longValue, unit);
        }
	throw new RuntimeException("Unknown format type for Method: " + 
            methodName);
    }
        
    // DataSheet addition
    private String appendDataValue(NonSyncStringBuffer buff, Node dataNode,
            String labelId, CCPropertySheetModelInterface model) {
        
	String methodName = getAttributeValue(dataNode, "method", null);
	String formatType = getAttributeValue(dataNode, "formatType", "String");
        String unit = getAttributeValue(dataNode, "unit", null);
        try {
            if (unit != null && unit.startsWith("$")) {
                unit = evaluate(getCurrentData(), unit, "String", null);
            }
        } catch (Exception ex) {
            // ignore
        }
        
        String value = "No Method defined!";
        try {
            if (methodName != null)
                value = evaluate(getCurrentData(), methodName, formatType, unit);
        } catch (Exception ex) {
            value = ex.getMessage();
        }
        
	if (labelId != null) {
	    // just static text, so need to put text inside span tag with an ID.
	    buff.append("<span id=\"")
		.append(labelId)
		.append("\" class=\"" + CCStyle.CONTENT_DEFAULT_TEXT + "\">")
		.append(value)
		.append("</span>");
	} else {
	    buff.append(value);
	}
        return null;
    }
    
    /* END JSTYLED */


    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Utility helper methods
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // XML Helper Methods.
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // ASPropertySheet addition
    private NodeList getTemplates(CCPropertySheetModelInterface model) {
	return model.getDocument().getElementsByTagName(TEMPLATE_ELEMENT);
    }

    protected String getDefaultValue(Node node) throws JspException {
	String html = getAttributeValue(node,
	    CCPropertySheetModelInterface.DEFAULT_ATTRIBUTE, null);
	if (html != null) {
            // ASPropertySheet addition
            if (html.indexOf('$') == 0) {
                try {
                    return getMessage(evaluate(getCurrentData(), html, "String", null));
                } catch (Exception ex) {
                    return ex.getMessage();
                }
            }
	    return getMessage(html);
        } else {
	    return "";
        }
    }

    protected boolean hasNoValueElement(Node propertyNode) {
        // return true is there are no CC nodes specified for the property
	NodeList subNodes = propertyNode.getChildNodes();
	for (int i = 0; i < subNodes.getLength(); i++) {
	    Node valueNode = subNodes.item(i);
	    String nodeName = valueNode.getNodeName();
	    if (nodeName != null
		    && (nodeName.equalsIgnoreCase(CCDescriptor.CC_ELEMENT)
                        // ASPropertySheet addition
		        || nodeName.equalsIgnoreCase(DATA_ELEMENT))) {
		return false;
	    }
	}
	return true;
    }

    protected void appendJumpLinks(NonSyncStringBuffer buff, NodeList sections)
	throws JspException {
	int count = numberOfSections; // sections.getLength();
	if (count == 0)
	    return;

	String names [] = new String [count];
	String anchors [] = new String [count];
	for (int i = 0; i < count; i++) {
	    Node sectionNode = sections.item(i);
	    // section names are required.
            iCurrentSection = i;
	    names[i] = getNameHTML(sectionNode);
	    anchors[i] = getAnchor(sectionNode);
            // ASPropertySheet addition
            if (anchors[i].equals(""))
                anchors[i] = names[i];
	}
	// start jump table part
	buff.append("<div class=\"" +
	    CCStyle.CONTENT_JUMP_SECTION_DIV +
	    "\">\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">" +
	    "<tr>\n");

	// This implements the layout for the jump links as specified by
	// HCI Admin. Should have 2, 3, or 4 links per row depending on the
	// number of total links. Should never have any more that 4 links
	// per row. At least that's what the current guideline says.
	if (count < 5)
	    appendJumpLinks(buff, names, anchors, count, 2);
	else if (count < 10)
	    appendJumpLinks(buff, names, anchors, count, 3);
	else
	    appendJumpLinks(buff, names, anchors, count, 4);

	// end jump table part
	buff.append("</tr></table></div>\n");

	// Some test code for the jump link layout algorithm.
//	for (count = 2 ; count < 16; count++) {
//	    switch (count) {
//		case 2:
//		case 3:
//		case 4:
//		    test(count, 2);
//		    break;
//		case 5:
//		case 6:
//		case 7:
//		case 8:
//		case 9:
//		    test(count, 3);
//		    break;
//		default:
//		    test(count, 4);
//		    break;
//	    }
//	}
    }
    /* END JSTYLED */
    
    protected boolean hasJumpLinks() {
	if (numberOfSections > 2) {
	    // if getShowJumpLinks() returns null,
	    // then .booleanValue() will return false.
	    return new Boolean(getShowJumpLinks()).booleanValue();
	}
	return false;
    }
}
