/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * CommonHandlers.java
 *
 */

package com.sun.enterprise.tools.admingui.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Enumeration;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.util.RootCauseException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.DisplayFieldImpl;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.html.SelectableGroup;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.event.ViewRequestInvocationEvent;
import com.iplanet.jato.view.event.ViewCommandEvent;

import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.Attribute;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCPropertySheetDescriptor;
import com.sun.enterprise.tools.guiframework.model.ModelManager;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCTabs;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.ViewDescriptorManager;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.enterprise.tools.guiframework.view.event.ErrorEvent;

import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.taglib.html.CCDropDownMenuTag;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import com.sun.web.ui.view.tabs.CCTabs;

import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;


/**
 *
 */
public class AdvanceTabHandler {

    
    public void displayAutoStart(RequestContext ctx, HandlerContext handlerCtx) throws Exception {
        View view = handlerCtx.getView();
	DescriptorContainerView descView = (DescriptorContainerView)view;
        String propertyName = (String)handlerCtx.getInputValue("propertyName");
        String methodName = (String)handlerCtx.getInputValue(METHOD_NAME);
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
	
	ViewDescriptor propertySheetDescriptor = descView.getViewDescriptor();
	if (propertySheetDescriptor == null) {
	    throw new FrameworkException("displayAutoStart: propertySheetDescriptor is null", propertySheetDescriptor, view);
	}
	if(!(propertySheetDescriptor instanceof CCPropertySheetDescriptor)) {
	    throw new FrameworkException("displayAutoStart: propertySheetDescriptor is of wrong type", propertySheetDescriptor, view);
	}
        CCPropertySheetModelInterface model = ((CCPropertySheetDescriptor)propertySheetDescriptor).getModel();
	
	if (isAutoStartSupported(objectName, methodName)) {
	    model.setVisible(propertyName, true);
            handlerCtx.setOutputValue(VALUE, "true");
	} else {
	    model.setVisible(propertyName, false);
            handlerCtx.setOutputValue(VALUE, "false");
        }
    }
    
    private boolean isAutoStartSupported(String objectName, String methodName) throws Exception {
	Boolean value = (Boolean)MBeanUtil.invoke(new ObjectName(objectName), methodName, null, null);
	
	boolean returnValue = false;
	
	if (value != null) {
	    returnValue =  value.booleanValue();
	}
	
	return returnValue;
	
    }
    
    public void saveAutoStart(RequestContext ctx, HandlerContext handlerCtx) throws Exception {
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        String value = (String)handlerCtx.getInputValue("displayFieldValue");
        String methodName = (String)handlerCtx.getInputValue(METHOD_NAME);
	
        if(!isAutoStartSupported(objectName, "isAutoStartSupported")) {
            return;
        }
        
	if(objectName == null || methodName == null) {
	    return;
	}
	MBeanUtil.invoke(objectName, methodName, new Object[]{new Boolean(value)},
				new String[]{"boolean"});
    }
    
    public void getAdvanceTabValuesFromMBean(RequestContext ctx, HandlerContext handlerCtx) throws Exception {
        View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
		throw new FrameworkException("View is not a DescriptorContainerView!", null, view);
            }  else {
                view = parent;
            }
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        String attributeName = (String)handlerCtx.getInputValue(ATTR_NAME);
        String childName = (String)handlerCtx.getInputValue(CHILD_NAME);
        String showTimeout = (String)handlerCtx.getInputValue("showTimeout");
        
        String value = null;
        try {
            value = (String)MBeanUtil.getAttribute(objectName, attributeName);
        } catch (Exception ex) {
	    throw new FrameworkException(
		"Exception throw in trying to get "+childName +" :"+ex);
        }
        if(showTimeout != null && showTimeout.equals("true")) {
            if (value == null || value.equals("")) {
                HttpServletRequest req = RequestManager.getRequestContext().getRequest();
                int time = req.getSession().getMaxInactiveInterval();
                if (time <= 0)
                    descView.setDisplayFieldValue(childName, "0");
                else
                    descView.setDisplayFieldValue(childName,""+(time/60));
            } else {
                descView.setDisplayFieldValue(childName, value);
            }
        }
        else {
            descView.setDisplayFieldValue(childName, value);
        }
    }
    
    public void getAutoStart(RequestContext ctx, HandlerContext handlerCtx) throws Exception {
        View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
		throw new FrameworkException("View is not a DescriptorContainerView!", null, view);
            }  else {
                view = parent;
            }
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        String methodName = (String)handlerCtx.getInputValue(METHOD_NAME);
        String childName = (String)handlerCtx.getInputValue(CHILD_NAME);
        
        Boolean retValue = (Boolean)MBeanUtil.invoke(objectName, methodName, null, null);
        
        if(retValue != null) {
            CCCheckBox cb = (CCCheckBox)descView.getChild(childName);
            ((CCCheckBox)cb).setValue(retValue.toString());
        }
        
    }
    
    public void saveAdvanceTabValues(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        String attributeName = (String)handlerCtx.getInputValue(ATTR_NAME);
        String value = (String)handlerCtx.getInputValue("displayFieldValue");
        
        Attribute attr = new Attribute(attributeName, value);
        
        MBeanUtil.setAttribute(objectName, attr);
        
    }
    
    public void restoreDefaultValues(RequestContext reqCtx, HandlerContext handlerCtx) {
	View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
		throw new FrameworkException("View is not a DescriptorContainerView!", null, view);
            }  else {
                view = parent;
            }
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;
        String childName = (String)handlerCtx.getInputValue(CHILD_NAME);
        String objectName = (String)handlerCtx.getInputValue(OBJECT_NAME);
        String[] params = {(String)handlerCtx.getInputValue(ATTR_NAME)};
        String[] types = {"java.lang.String"};
        descView.setDisplayFieldValue(childName,
                    MBeanUtil.invoke(objectName, "getDefaultAttributeValue", params, types));  
        String value = (String)MBeanUtil.invoke(objectName, "getDefaultAttributeValue", params, types);
        
    }
    
    private String OBJECT_NAME = "objectName";
    private String CHILD_NAME = "childName";
    private String ATTR_NAME = "attributeName";
    private String METHOD_NAME = "methodName";
    private String VALUE = "value";
    
}
