<%--
 The contents of this file are subject to the terms 
 of the Common Development and Distribution License 
 (the License).  You may not use this file except in
 compliance with the License.
 
 You can obtain a copy of the license at 
 https://glassfish.dev.java.net/public/CDDLv1.0.html or
 glassfish/bootstrap/legal/CDDLv1.0.txt.
 See the License for the specific language governing 
 permissions and limitations under the License.
 
 When distributing Covered Code, include this CDDL 
 Header Notice in each file and include the License file 
 at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 If applicable, add the following below the CDDL Header, 
 with the fields enclosed by brackets [] replaced by
 you own identifying information: 
 "Portions Copyrighted [year] [name of copyright owner]"
 
 Copyright 2006 Sun Microsystems, Inc. All rights reserved.
--%>

<%@ page info="webServiceRTGraph" language="java" contentType="text/html; charset=UTF-8" %>
<%@taglib uri="/jato.tld" prefix="jato"%>
<%@taglib uri="/cc.tld" prefix="cc"%>

<jato:useViewBean type="com.iplanet.jato.view.ViewBean" className="webServiceRTGraph">

<cc:header pageTitle="webServiceRealtimeGraph.PageTitle" copyrightYear="2005" name="HtmlHeader"
 baseName="com.sun.enterprise.tools.admingui.resources.Resources" bundleID="testBundle">
 

<!-- Form -->
<jato:form name="Form" method="POST" >

<script type="text/javascript">
    var refreshRate = 5000;
    var duration = 3600000;
    var timerID ;
    
 function reloadImage() {
    uniq = new Date();
    uniq = "&uniq="+uniq.getTime();
    nm = document.getElementById('serverWsKey').value;
    duration_str="&duration="+duration;
    resp = document.getElementById('wsResponseTimeRTChart');
    resp.src = '../admingui/ChartViewer?chartName=wsResponseTimeRTChart-' + nm + '&RT=true&width=400&height=260'+uniq+duration_str;
    
    throughput = document.getElementById('wsThroughputRTChart');
    throughput.src= '../admingui/ChartViewer?chartName=wsThroughputRTChart-' + nm + '&RT=true&width=400&height=260'+uniq+duration_str;
    
    count = document.getElementById('wsCountRTChart');
    count.src= '../admingui/ChartViewer?chartName=wsCountRTChart-' + nm + '&RT=true&width=400&height=260'+uniq+duration_str;
  
    auth = document.getElementById('wsAuthRTChart');
    auth.src= '../admingui/ChartViewer?chartName=wsAuthRTChart-' + nm + '&RT=true&width=400&height=260'+uniq+duration_str;
    
    clearTimeout(timerID);
    timerID = setTimeout("reloadImage()", refreshRate);
    }
    
    
   function changeRefreshRate(){
   
        refresh = document.getElementById('refreshRate');
        if (checkForIntValue(refresh) == false){
            alert(getMessage("realtimeGraph.posRefreshRate"));
            return false;
        }
        if (refresh.value <= 0){
            alert(getMessage("realtimeGraph.zeroWarning"));
            return false;
        }
        durationField = document.getElementById('duration');
        if (checkForIntValue(durationField) == false){
            alert(getMessage("realtimeGraph.posDuration"));
            return false;
        }
        if (durationField.value <= 0){
            alert(getMessage("realtimeGraph.zeroDuration"));
            return false;
        }
        duration = durationField.value * 60 *1000;
        
        unit = document.getElementById('refreshRateUnit');
        refreshRate=refresh.value*unit.value*1000;
        
        if (duration <= refreshRate){
            alert(getMessage("realtimeGraph.durationError"));
            return false;
        }
        
        //alert("refresh="+refresh.value + " unit=" + unit.value + "refreshRate="+refreshRate + "duration"+duration);
        alert(getMessage("realtimeGraph.rateChanged"));
        clearTimeout(timerID);
        timerID = setTimeout("reloadImage()", refreshRate);
        return false;
   }
   
</script>

<!-- Bread Crumb component -->
<cc:breadcrumbs name="BreadCrumb" bundleID="testBundle" useGrayBg="true" />

<div class="ConMgn">
<cc:alertinline name="Alert" bundleID="testBundle" />
</div>

<jato:content name="resourceStrings">
realtimeGraph.posRefreshRate
realtimeGraph.zeroWarning
realtimeGraph.posDuration
realtimeGraph.zeroDuration
realtimeGraph.rateChanged
realtimeGraph.durationError
</jato:content>


<!-- Page Title --> 
<cc:pagetitle name="PageTitle" bundleID="testBundle"
 pageTitleText="webServiceRealtimeGraph.PageTitle" 
 showPageTitleSeparator="true"
 showPageButtonsTop="true"
 showPageButtonsBottom="false">
 
<cc:propertysheet name="webServiceRTGraph" bundleID="testBundle" addJavaScript="true"/> 
 
<table border="0" cellpadding="0" cellspacing="5" title="">
<tr>
<td valign="top">
    <div class="ConTblCl2Div"> 
        <cc:image name="wsResponseTimeRTChart" bundleID="testBundle" 
            defaultValue="../images/dot.gif" 
            border="0" height="260" width="400" elementId="wsResponseTimeRTChart" />
    </div>
</td>
<td>
    <div class="ConTblCl2Div">
       <cc:image name="wsThroughputRTChart" bundleID="testBundle" 
            defaultValue="../images/dot.gif" 
            border="0" height="260" width="400" elementId="wsThroughputRTChart" />
    </div>
</td>
</tr>
<tr>
<td>
    <div class="ConTblCl2Div">
       <cc:image name="wsAuthRTChart" bundleID="testBundle" 
            defaultValue="../images/dot.gif"
            border="0" height="260" width="400" elementId="wsAuthRTChart" />
    </div>
</td>
<td>
    <div class="ConTblCl2Div">
       <cc:image name="wsCountRTChart" bundleID="testBundle" 
            defaultValue="../images/dot.gif"
            border="0" height="260" width="400" elementId="wsCountRTChart" />
    </div>
</td>
</tr>
</table>

<jato:content name="extra">
</jato:content>

</cc:pagetitle>
</jato:form>
</body>
</cc:header>
</jato:useViewBean>
