/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * PWCHttpServiceStats.java
 *
 * Created on April 2, 2004, 9:25 AM
 */

package com.sun.enterprise.admin.monitor.stats;

/**
 *
 * @author  nsegura
 */

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Stats;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
/**
 * Contains Statistical Information for the HttpService
 */
public interface PWCHttpServiceStats extends Stats {
    
    /** 
     * Returns HttpService Id
     * @return HttpService Id
     */
    public StringStatistic getID();
    
    /** 
     * Returns the HttpService Version
     * @return HttpService Version
     */
    public StringStatistic getVersionServer();
    
    /** 
     * Returns the Time the HttpService Was Started
     * @return Time HttpService Started
     */
    public StringStatistic getTimeStarted();
    
    /** Returns the amount of seconds the HttpService has been running
     * @return seconds HttpService has been running
     */
    public CountStatistic getSecondsRunning();
       
    /** Returns the max amount of threads
     * @return the max amount of threads
     */
    public CountStatistic getMaxThreads();
    
    /** 
     * The Max amount of virtual servers
     * @return Max amount of virtual servers
     */
    public CountStatistic getMaxVirtualServers();
    
    /** 
     * Returns 1 if profiling is enabled, otherwise 0
     * @return profile enabled?
     */
    public CountStatistic getFlagProfilingEnabled();
    
    /** 
     * Returns 1 if virtual server overflow is enable, otherwise 0
     * @return virtual sever overflow enabled?
     */
    public CountStatistic getFlagVirtualServerOverflow();
    
    /** 
     * Returns the average load in the last minute
     * @return average 1 minute load
     */
    public CountStatistic getLoad1MinuteAverage();
    
    /** 
     * Returns the average load for the last 5 minutes
     * @return average 5 minute load
     */
    public CountStatistic getLoad5MinuteAverage();
    
    /** 
     * Returns the average load for the last 15 minutes
     * @return average 15 minute load
     */
    public CountStatistic getLoad15MinuteAverage();
    
    /**
     * Returns the rate of bytes transmitted
     * @return byte trasmission rate
     */    
    public CountStatistic getRateBytesTransmitted();
    
    /** 
     * Returns the rate of bytes received
     * @return byte receive rate
     */    
    public CountStatistic getRateBytesReceived();
    
}
