/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * PWCDnsStats.java
 *
 * Created on April 2, 2004, 10:37 AM
 */

package com.sun.enterprise.admin.monitor.stats;

/**
 *
 * @author  nsegura
 */
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;

/** 
 * The DNS Cache caches IP addresses and DNS names. The server’s DNS cache is
 * disabled by default. A single cache entry represents a single IP address or DNS
 * name lookup
 */
public interface PWCDnsStats extends Stats {
    
    /**
     * Indicates whether the DNS cache is enabled or disable. Default is disabled.
     * @return DNS cache enabled?
     */
    public CountStatistic getFlagCacheEnabled();
    
    /** 
     * The number of current cache entries
     * @return current cache entries
     */
    public CountStatistic getCountCacheEntries();
    
    /** 
     * The maximum number of cache entries
     * @return max cache entries
     */
    public CountStatistic getMaxCacheEntries();
    
    /** 
     * The number of cache hits
     * @return cache hits
     */
    public CountStatistic getCountCacheHits();
    
    /** 
     * The number of cache misses
     * @return cache misses
     */
    public CountStatistic getCountCacheMisses();
    
    /** 
     * Returns whether asynchronic lookup is enabled. 1 if true, 0 otherwise
     * @return enabled
     */
    public CountStatistic getFlagAsyncEnabled();
    
    /** 
     * The total number of asynchronic name lookups
     * @return asyn name lookups
     */
    public CountStatistic getCountAsyncNameLookups();
    
    /** 
     * The total number of asynchronic address lookups
     * @return asyn address lookups
     */
    public CountStatistic getCountAsyncAddrLookups();
    
    /** 
     * The number of asynchronic lookups in progress
     * @return async lookups in progress
     */
    public CountStatistic getCountAsyncLookupsInProgress();
    
}
