/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.monitor.stats;

import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Stats;

/**
 * A Stats interface to represent the statistical data about 
 * Work Management in the Connector Module
 * 
 * @author  Murali Vempaty
 * @since   SJSAS8.1
 */

public interface ConnectorWorkMgmtStats extends Stats {
    
    /**
     * returns the current, low & high counts of the work objects executed for
     * a connector module since the last reset. This is an aggregate of all the
     * doWork, doSchedule, and doStart work objects initiated by the connector
     * module
     * @return RangeStatistic
     */
    public RangeStatistic getActiveWorkCount();
    
    /**
     * indicates the current, high & low of the number of work objects waiting 
     * in the work queue before executing, since the last reset
     * @return RangeStatistic
     */
    public RangeStatistic getWaitQueueLength();
    
    /**
     * indicates the longest and shorted wait of a work object in the work queue
     * before it gets executed, since the last reset
     * @return RangeStatistic
     */
    public RangeStatistic getWorkRequestWaitTime();
    
    /**
     * indicates the number of work objects submitted by a connector module 
     *  for execution, since the last reset
     * @return CountStatistic
     */
    public CountStatistic getSubmittedWorkCount();
    
    /**
     * indicates the number of work objects rejected by the Application Server
     * per connector module, since the last reset.
     * @return CountStatistic
     */
    public CountStatistic getRejectedWorkCount();
    
    /**
     * indicates the number of work objects that were completed by the 
     * Application Server per connector module, since the last reset.
     * @return CountStatistic
     */
    public CountStatistic getCompletedWorkCount();
    
}
