
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/stringifier/Attic/X509CertificateStringifier.java,v 1.3 2005/12/25 03:52:02 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:52:02 $
 */
 
package com.sun.appserv.management.util.stringifier;


import java.security.cert.X509Certificate;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import com.sun.appserv.management.util.misc.StringUtil;


/**
	Stringifies an X509CertificateStringifier.
 */
 
public final class X509CertificateStringifier implements Stringifier
{
	public final static X509CertificateStringifier	DEFAULT	= new X509CertificateStringifier();
	
		public
	X509CertificateStringifier()
	{
	}
	
	
		private static byte[]
	getFingerprint( byte[] signature, String alg )
	{
		byte[]	result	= null;
		
		try
		{
			final MessageDigest md = MessageDigest.getInstance( alg );
			
			result	= md.digest( signature );
		}
		catch ( NoSuchAlgorithmException e )
		{
			result	= signature;
			e.printStackTrace();
		}
		
		return( result );
	}
	
	/**
		Static variant when direct call will suffice.
	 */
		public static String
	stringify( final X509Certificate cert )
	{
		final StringBuffer	buf	= new StringBuffer();
		final String		NL	= "\n";
		
		buf.append( "Issuer: " + cert.getIssuerDN().getName() + NL);
		buf.append( "Issued to: " + cert.getSubjectDN().getName()  + NL);
		buf.append( "Version: " + cert.getVersion()  + NL);
		buf.append( "Not valid before: " + cert.getNotBefore()  + NL);
		buf.append( "Not valid after: " + cert.getNotAfter()  + NL);
		buf.append( "Serial number: " + cert.getSerialNumber()  + NL);	
		buf.append( "Signature algorithm: " + cert.getSigAlgName()  + NL);	
		buf.append( "Signature algorithm OID: " + cert.getSigAlgOID()  + NL);
		
		buf.append( "Signature fingerprint (MD5): " );
		byte[]	fingerprint	= getFingerprint( cert.getSignature(), "MD5" );
		buf.append( StringUtil.toHexString( fingerprint, ":" ) + NL );
		
		buf.append( "Signature fingerprint (SHA1): " );
		fingerprint	= getFingerprint( cert.getSignature(), "SHA1" );
		buf.append( StringUtil.toHexString( fingerprint, ":" )  + NL );
		
		return( buf.toString() );
	}
	
		public String
	stringify( Object object )
	{
		return( stringify( (X509Certificate)object ) );
	}
}

