/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/jmx/stringifier/Attic/StringifierRegistryIniter.java,v 1.5 2005/12/25 03:51:40 tcfujii Exp $
 * $Revision: 1.5 $
 * $Date: 2005/12/25 03:51:40 $
 */
 
package com.sun.appserv.management.util.jmx.stringifier;

import javax.management.*;
import javax.management.modelmbean.*;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;

import com.sun.appserv.management.util.jmx.stringifier.*;


import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.Statistic;
import com.sun.appserv.management.util.j2ee.stringifier.*;

import com.sun.appserv.management.util.stringifier.StringifierRegistry;

/**
	Registers all included stringifiers with the default registry.
 */
public class StringifierRegistryIniter extends
	com.sun.appserv.management.util.stringifier.StringifierRegistryIniterImpl
{
		public
	StringifierRegistryIniter( StringifierRegistry registry )
	{
		super( registry );
		
		add( ObjectName.class, ObjectNameStringifier.DEFAULT );
		add( MBeanInfo.class, MBeanInfoStringifier.DEFAULT );
		add( ModelMBeanInfo.class, ModelMBeanInfoStringifier.DEFAULT );
		
		add( MBeanOperationInfo.class, MBeanOperationInfoStringifier.DEFAULT );
		add( ModelMBeanOperationInfo.class, ModelMBeanOperationInfoStringifier.DEFAULT );
		
		add( MBeanAttributeInfo.class, MBeanAttributeInfoStringifier.DEFAULT );
		add( ModelMBeanAttributeInfo.class, ModelMBeanAttributeInfoStringifier.DEFAULT );
		
		add( MBeanParameterInfo.class, MBeanParameterInfoStringifier.DEFAULT );
		
		add( MBeanNotificationInfo.class, MBeanNotificationInfoStringifier.DEFAULT );
		add( ModelMBeanNotificationInfo.class, ModelMBeanNotificationInfoStringifier.DEFAULT );
		
		add( MBeanConstructorInfo.class, MBeanConstructorInfoStringifier.DEFAULT );
		add( ModelMBeanConstructorInfo.class, ModelMBeanConstructorInfoStringifier.DEFAULT );
		
		add( Attribute.class, AttributeStringifier.DEFAULT );
		add( AttributeList.class, AttributeListStringifier.DEFAULT );
		
		add( Notification.class, NotificationStringifier.DEFAULT );
		add( AttributeChangeNotification.class, AttributeChangeNotificationStringifier.DEFAULT );
		add( MBeanServerNotification.class, MBeanServerNotificationStringifier.DEFAULT );
		
		
		add( CompositeData.class, CompositeDataStringifier.DEFAULT );
		add( CompositeDataSupport.class, CompositeDataStringifier.DEFAULT );
		add( TabularData.class, TabularDataStringifier.DEFAULT );
		add( TabularDataSupport.class, TabularDataStringifier.DEFAULT );
		
		try
		{
		    add( Stats.class, StatsStringifier.DEFAULT );
		    add( Statistic.class, StatisticStringifier.DEFAULT );
		}
		catch( Throwable t )
		{
		}
	}
}



