/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.jmx;

import javax.management.Attribute;

public final class AttributeComparator implements java.util.Comparator<Attribute>
{
	public static final AttributeComparator	INSTANCE	= new AttributeComparator();
	
	private	AttributeComparator()	{}
	
		public int
	compare( Attribute attr1, Attribute attr2 )
	{
		int	result	= attr1.getName().compareTo( attr2.getName() );
		if ( result == 0 )
		{
			result	= attr1.getValue().toString().compareTo( attr2.getValue().toString() );
		}
		
		return( result );
	}
	
		public boolean
	equals( Object other )
	{
		return( other instanceof AttributeComparator );
	}
}


