/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.j2ee.stringifier;

import java.util.Arrays;

import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.Statistic;

import com.sun.appserv.management.util.stringifier.Stringifier;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;

/**
	Stringifier for javax.management.j2ee.statistics 
 */
public class StatsStringifier implements Stringifier
{
	public static final StatsStringifier	DEFAULT	= new StatsStringifier();
	
		public
	StatsStringifier( )
	{
	}
	
		public String
	stringify( Object o )
	{
		final Stats			stats	= (Stats)o;
		final String []		names	= stats.getStatisticNames();
		
		Arrays.sort( names );
		
		final StringBuffer	buf	= new StringBuffer();
		
		buf.append( "Stats: " + ArrayStringifier.stringify( names, ", " ) + "\n" );
		
		for( int i = 0; i < names.length; ++i )
		{
			final Object	statistic	= stats.getStatistic( names[ i ] );
			
			buf.append( SmartStringifier.toString( statistic ) );
			buf.append( "---\n" );
		}
		buf.append( "\n" );
		
		return( buf.toString() );
	}
}



















