/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.monitor.statistics;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;

/** 
 * A Stats interface to represent the statistical data exposed by an
 * HTTP Listener. This include data about the GlobalRequestProcessor
 * and the ThreadPool.
 * The GlobalRequestProcessor collects data about request processing 
 * from each of the RequestProcessor threads.
 * @since S1AS8.0
 * @version 1.0
 */
public interface HTTPListenerStats extends Stats
{
    
    // GlobalRequestProcessor statistics for the listener
    // TODO: Consolidate the statistics into Boundary or BoundedRange
    // statistics, as necessitated. For now, will leave everything
    // as a CountStatistic
    
    /**
     * Cumulative value of the bytesReceived by each of the
     * RequestProcessors
     * @return CountStatistic
     */
    public CountStatistic getBytesReceived();

    /**
     * Cumulative value of the bytesSent by each of the
     * RequestProcessors
     * @return CountStatistic
     */
    public CountStatistic getBytesSent();
    
    /**
     * Cumulative value of the errorCount of each of the
     * RequestProcessors. The errorCount represents the number of
     * cases where the response code was >= 400
     * @return CountStatistic
     */
    public CountStatistic getErrorCount();
    
    ;
    
    
    /**
     * @return CountStatistic
     */
    public CountStatistic getCount200();
    public CountStatistic getCount2xx();
    public CountStatistic getCount302();
    public CountStatistic getCount304();
    public CountStatistic getCount3xx();
    public CountStatistic getCount400();
    public CountStatistic getCount401();
    public CountStatistic getCount403();
    public CountStatistic getCount404();
    public CountStatistic getCount4xx();
    public CountStatistic getCount503();
    public CountStatistic getCount5xx();
    public CountStatistic getCountOther();
    
    
    
    public CountStatistic getCountOpenConnections();
    public CountStatistic getMaxOpenConnections();
    
    
    /**
     * The longest response time for a request. This is not a
     * cumulative value, but is the maximum of the response times
     * for each of the RequestProcessors.
     * @return CountStatistic
     */
    public CountStatistic getMaxTime();
    
    /**
     * Cumulative value of the processing times of each of the
     * RequestProcessors. The processing time of a RequestProcessor
     * is the average of request processing times over the request
     * count.
     * @return CountStatistic
     */
    public CountStatistic getProcessingTime();
    
    /**
     * Cumulative number of the requests processed so far, 
     * by the RequestProcessors.
     * @return CountStatistic
     */
    public CountStatistic getRequestCount();
    
    
    //ThreadPool statistics for the listener
    
    /**
     * The number of request processing threads currently in the
     * thread pool
     * @return CountStatistic
     */
    public CountStatistic getCurrentThreadCount();
    
    /**
     * The number of request processing threads currently in the
     * thread pool, serving requests.
     * @return CountStatistic
     */
    public CountStatistic getCurrentThreadsBusy();
    
    /**
     * The maximum number of request processing threads that are
     * created by the listener. It determines the maximum number of
     * simultaneous requests that can be handled
     * @return CountStatistic
     */
    public CountStatistic getMaxThreads();
    
    /** 
     * The maximum number of unused request processing threads that will
     * be allowed to exist until the thread pool starts stopping the 
     * unnecessary threads.
     * @return CountStatistic
     */
    public CountStatistic getMaxSpareThreads();

    /**
     * The number of request processing threads that will be created 
     * when this listener is first started.
     * @return CountStatistic
     */
    public CountStatistic getMinSpareThreads();
    
}
