/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 

package com.sun.appserv.management.ext.logging;

/**
	Interface which can be applied over the CompositeData returned
	from {@link LogQuery#queryServerLog}.
	
	@since AS 9.0
	@see LogQueryEntry
	@see LogQuery
 */
public interface LogQueryResult
{
    /**
        Get field names for each field of a {@link LogQueryEntry}.
        Log entries in the server <i>log file</i> are of the form:<br>
        <code><pre>[#|DATE|LEVEL|PRODUCT_NAME|MODULE|NAME_VALUE_PAIRS|MESSAGE|#]</pre></code><br>
        The metadata contains most of these fields, but does <b not> contain
        the PRODUCT_NAME or '#' columns.
     */
    public String[]    getFieldNames();
    
    /**
        Return all log entries found by the query <b>not including the field headers</b>.
     */
    public LogQueryEntry[]  getEntries();
}






