/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;



/**
    Represents the &lt;event-config> element.<p>
    Contained in {@link ManagementRuleConfig}.
      
	@since Appserver 9.0
	@see ManagementRuleConfig
	@see ActionConfig
*/
public interface EventConfig
    extends ConfigElement, Description, PropertiesAccess  
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.EVENT_CONFIG;
	
	/**
	    @see EventTypeValues
	 */
	public String   getType();
	/**
	    Value must be one of the types given by {@link EventTypeValues}.
	    @see EventTypeValues
	 */
	public void     setType( String type );
	
	/**               
        Specifies whether the occurance of the event is to be logged  
        or not. By default this would be true. If no action is        
        specified, the event would be recorded.                    
	 */
	public boolean  getRecordEvent();
	
	/* @see #getRecordEvent */
	public void     setRecordEvent( boolean recordIt );
	
	/**           
        Specifies at what level to record the event occurance in      
        server log file. Default value is INFO.
	 */
	public String   getLevel();
	
	/* @see #getLevel */
	public void     setLevel( String level );
	
}
