/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client.handler;

import javax.management.ObjectName;
import java.util.Iterator;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;

/**
    <b>INTERNAL interface, do not use</b>
	A proxy cache is shared by all Proxies obtained through the
	same DomainRoot.
 */
public final class ProxyCache extends CacheBase<ObjectName, AMX>
{
		public
	ProxyCache()
	{
	}
	
	/**
		Cache a proxy using any desired key.
	 */
		public void
	cacheProxy( final AMX	proxy )
	{
		final ObjectName	objectName	= Util.getExtra( proxy ).getObjectName();
		
		if ( getCachedProxy( objectName ) != null )
		{
			throw new IllegalArgumentException(
				"proxy already cached for: " + objectName );
		}
		
		cacheItem( objectName, proxy );
	}
	
		public AMX
	getCachedProxy( final ObjectName key )
	{
	    return getCachedItem( key );
	}
	
}





