/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client;

import java.util.Map;
import java.io.Serializable;

import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.appserv.management.ext.wsmgmt.MessageTrace;
import com.sun.appserv.management.ext.wsmgmt.MessageTraceImpl;

import static com.sun.appserv.management.base.
                MapCapable.MAP_CAPABLE_CLASS_NAME_KEY;
import static com.sun.appserv.management.deploy.
                DeploymentProgress.DEPLOYMENT_PROGRESS_CLASS_NAME;
import static com.sun.appserv.management.deploy.DeploymentSource.
                DEPLOYMENT_SOURCE_CLASS_NAME;
import static com.sun.appserv.management.deploy.DeploymentStatus.
                DEPLOYMENT_STATUS_CLASS_NAME;

/**
    Converts Maps obtained from the server back into their
    proprietary (non-standard) java types.
 */
public final class MapConverter
{
    private MapConverter()  {}
    
    /**
        Of course there are more elaborate ways to do this, but given the small
        number of conversions, this straightforward approach is best.
     */
        private static Object
    doConvert( final Map<String,Serializable> m )
    {
        Object  result  = m;    // don't convert, by default
        
        final String interfaceName = (String)m.get(MAP_CAPABLE_CLASS_NAME_KEY);
        if ( interfaceName != null )
        {
            if ( DEPLOYMENT_PROGRESS_CLASS_NAME.equals( interfaceName ) )
            {
                result  = DeploymentSupport.mapToDeploymentProgress( m );
            }
            else if ( DEPLOYMENT_SOURCE_CLASS_NAME.equals( interfaceName ) )
            {
                result  = DeploymentSupport.mapToDeploymentSource( m );
            }
            else if ( DEPLOYMENT_STATUS_CLASS_NAME.equals( interfaceName ) )
            {
                result  = DeploymentSupport.mapToDeploymentStatus( m );
            }
            else if ( MessageTrace.CLASS_NAME.equals( interfaceName ) )
            {
                result  = new MessageTraceImpl( m, MessageTrace.class.getName());
            }
            else
            {
                // That's OK, we just leave it as a Map
            }
        }
        return result;
    }
    
    
    /**
        This form should be used where the appropriate class is not
        known in advance.
     */
        public static Object
    convert( final Map<String,Serializable> m )
    {
        return doConvert( m );
    }
    
    /**
        This form should be used where the appropriate class is known
        in advance.
     */
        public static <T> T
    convertToClass(
        final Map<String,Serializable> m,
        final Class<T>  theClass )
    {
        return theClass.cast( doConvert( m ) );
    }
}





