/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/admin/src/java/com/sun/enterprise/admin/dottedname/DottedNameRegistry.java,v 1.3 2005/12/25 03:47:32 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:47:32 $
 */
 
package com.sun.enterprise.admin.dottedname;
 
import java.util.Set;
import javax.management.ObjectName;



/*
	A registry for DottedName-to-ObjectName mapping.
 */
public interface DottedNameRegistry extends DottedNameQuery
{
	/*
		Add a mapping from a dotted name to an ObjectName.  If an existing
		mapping is present, it is replaced.  An exception may also
		be thrown if the dotted name is illegal or either parameter is null,
		or in general the implementing class does not allow such a mapping.
		
		Multiple dotted names may be associated with the same ObjectName; it is
		a policy decision of the caller whether to use that facility.
		
		@param dottedName	the dotted name to which the ObjectName should be associated
		@param objectName	the name of the MBean which associates with the dotted name.
	 */
	void	add( String dottedName, ObjectName objectName );
	
	/*
		Removes the entry associating the dotted name with an ObjectName. No error
		is produced if there is no such mapping.
		
		@param dottedName	the dotted name to which the ObjectName should be associated
	 */
	void	remove( String dottedName );
	
	/*
		Removes all dotted names associated with this ObjectName.  No error
		is produced if there is no such mapping.
		
		@param objectName	the ObjectName associated with one or more dotted names
	 */
	void	remove( ObjectName objectName );
}

