/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.util.HashMap;
import java.util.Vector;
import junit.framework.*;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.4 $
 */

public class CommandFactoryTest extends TestCase {
    public void testInvalidClass(){
        final ValidCommand vc = new ValidCommand();
        vc.setName("vc");
        vc.setNumberOfOperands("three");
        vc.setUsageText("vc 1 2 3");
        vc.setClassName("foobar");
        try {
            CommandFactory.createCommand(vc, new HashMap(), new Vector());
            fail("Expected a CommandValidationException indicating that the class could not be found");
        }
        catch (CommandValidationException cve){
            assertEquals("CLI002 Unable to create command object, vc.", cve.getMessage());
            assertEquals(ClassNotFoundException.class, cve.getCause().getClass());
            assertEquals("foobar", cve.getCause().getMessage());        }
    }
        
    public void testNullClass() {
        final ValidCommand vc = new ValidCommand();
        vc.setName("vc");
        vc.setNumberOfOperands("three");
        vc.setUsageText("vc 1 2 3");
        try {
            CommandFactory.createCommand(vc, new HashMap(), new Vector());
            fail("Expected a CommandValidationException indicating that no classname was given");
        }
        catch (CommandValidationException cve){
            assertEquals("CLI001 Invalid Command, vc.", cve.getMessage());
        }
    }
    
    public void testSimpleCommandCreation() throws Exception {
        final ValidCommand vc = new ValidCommand();
        vc.setName("vc");
        vc.setNumberOfOperands("three");
        vc.setUsageText("vc 1 2 3");
        vc.setClassName("com.sun.enterprise.cli.framework.TestCommand");
        assertNotNull(vc.getClassName());
        final Command c = CommandFactory.createCommand(vc, new HashMap(), new Vector());
        assertNotNull(c);
    }

    public void testNoArgsConstructor(){
        final CommandFactory c = new CommandFactory();
    }
    
    public CommandFactoryTest(String name){
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static void main(String args[]){
        if (args.length == 0){
            junit.textui.TestRunner.run(CommandFactoryTest.class);
        } else {
            junit.textui.TestRunner.run(makeSuite(args));
        }
    }
    private static TestSuite makeSuite(String args[]){
        final TestSuite ts = new TestSuite();
        for (int i = 0; i < args.length; i++){
            ts.addTest(new CommandFactoryTest(args[i]));
        }
        return ts;
    }
}

class TestCommand extends Command
{
    public void runCommand() throws com.sun.enterprise.cli.framework.CommandException, com.sun.enterprise.cli.framework.CommandValidationException{}
    public boolean validateOptions() throws com.sun.enterprise.cli.framework.CommandValidationException{
        return true;
    }
    
}

