/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LocalStringsManager.java
 *
 * Created on July 29, 2003, 4:26 PM
 */

package com.sun.enterprise.cli.framework;

//imports
import java.util.ResourceBundle;
import java.util.Locale;
import java.util.Vector;
import java.util.Properties;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.text.MessageFormat;

/**
 *
 * @author  pa100654
 */
public class LocalStringsManager {
    
    private String          packageName;
    private String          propertyFile;
    private Vector          resourceBundles = new Vector();
    public  static String   DEFAULT_STRING_VALUE = "Key not found";

    /** Creates a new instance of LocalStringsManager */
    public LocalStringsManager(String packageName, String propertyFile) 
    {
        this.packageName = packageName;
        this.propertyFile = propertyFile;
        ResourceBundle resourceBundle = 
                ResourceBundle.getBundle(packageName + "." + propertyFile);
        resourceBundles.add(resourceBundle);
    }
    
    /** Creates a new instance of LocalStringsManager from the 
        properties Vector 
     */
    public LocalStringsManager(Vector localizePropertiesList) 
    {
        for (int i = 0; i < localizePropertiesList.size(); i++)
        {
            Properties properties = (Properties) localizePropertiesList.get(i);
            String packageNameStr = (String) properties.get("base-package");
            String propertyFileStr = (String) properties.get("property-file-name");
            ResourceBundle resourceBundle = 
                ResourceBundle.getBundle(packageNameStr + "." + propertyFileStr);
            resourceBundles.add(resourceBundle);
        }
    }

        
    /** Creates a new instance of LocalStringsManager from the 
        properties Vector of Strings and locale 
     */
    public LocalStringsManager(Vector localizeStringList, Locale locale) 
    {
        for (int i = 0; i < localizeStringList.size(); i++)
        {
            ResourceBundle resourceBundle = 
                ResourceBundle.getBundle((String)localizeStringList.get(i),
                                         locale);
            resourceBundles.add(resourceBundle);
        }
    }

    
    /*
     *returns the property file name
     */
    public String getPropertiesFile()
    {
        return propertyFile;
    }
    
    /*
     * returns the base package name
     */
    public String getPackageName()
    {
        return packageName;
    }

    
    /*
     *returns resourceBundles
     */
    public Vector getResourceBundles()
    {
        return resourceBundles;
    }
    
    
    /*
     *  Returns the Localized string properties file
     */
    public String getString(String key)
    {
        Iterator resourcesIter = resourceBundles.iterator();
        String value = DEFAULT_STRING_VALUE + " (" + key + ")";
        while (resourcesIter.hasNext())
        {
            ResourceBundle resourceBundle = (ResourceBundle)resourcesIter.next();
            try
            {
                value = resourceBundle.getString(key);
                break;
            }
            catch (MissingResourceException mre)
            {
                // if not found, try next resource bundle in the iterator
            }
        }
        return value;
    }

    /*
     *  Return the Localized string with the inserted values
     */
    public String getString(String key, Object[] toInsert) 
                    throws CommandValidationException
    {
        String fmtStr = null;
        try
        {
            MessageFormat msgFormat = 
                            new MessageFormat(getString(key));
            fmtStr = msgFormat.format(toInsert);
        }
        catch(Exception e)
        {
            throw new CommandValidationException(e);
        }
        return fmtStr;
    }
}
