/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * CommandFactory.java
 *
 * Created on June 23, 2003, 4:01 PM
 */

package com.sun.enterprise.cli.framework;


import java.util.Vector;
import java.util.List;
import java.util.HashMap;

/**
 *  This is a factory class that creates a Command object.
 *    @version  $Revision: 1.4 $
 *    @author  pa100654
 */
public class CommandFactory 
{
    
    /** Creates a new instance of CommandFactory */
    public CommandFactory() 
    {
    }

    
    /**  The static class that creates the command object 
     *   @param commandMatched, the ValidCommand object that contains 
     *          vital info on the command.
     *   @param options, the options in command line
     *   @param operands,the operands in command line
     *   @throws  CommandValidationException if there is an error creating 
     *            the command.
     */
    public static Command createCommand(ValidCommand commandMatched, HashMap options, 
                                        HashMap envOptions, Vector operands) 
                                        throws CommandValidationException
    {
        Command command = null;
        String commandName = commandMatched.getName();
        String className = commandMatched.getClassName();
        if (className == null)
        {
	    LocalStringsManager lsm = 
		LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            throw new CommandValidationException(lsm.getString("InvalidCommand",
						 new Object[] {commandName} ));
        }
        try
        {
            Class  theClass = Class.forName(className);
            command = (Command)theClass.newInstance();
            command.setName(commandName);
            command.setCLOptions(options);
            command.setEnvOptions(envOptions);

            command.setOperands(determineOperand(operands,
                                                 commandMatched.getDefaultOperand()));
            
            //command.setOperands(operands);
            command.setUsageText(commandMatched.getUsageText());        
            command.setProperties(commandMatched.getProperties());
	    command.setBooleanOptions(constructBooleanOptionsList(commandMatched));
        }
        catch(Exception e)
        {
	    LocalStringsManager lsm = 
		LocalStringsManagerFactory.getFrameworkLocalStringsManager();
	    throw new CommandValidationException(lsm.getString("UnableToCreateCommand",
					         new Object[] {commandName}), e);
            //e.printStackTrace();
        }
        return command;
    }


    /**
     * Create a list of boolean options for this command.
     * @param ValidCommand contains the list of required and valid options.
     * @return list of boolean options.
     */
    private static List constructBooleanOptionsList(ValidCommand validCommand)
    {
	List booleanOptionsList = new Vector();
	final Vector requiredOptions = validCommand.getRequiredOptions();
	for (int ii=0; ii<requiredOptions.size(); ii++)
	{
	    final ValidOption validOption = (ValidOption)requiredOptions.get(ii);
	    if (validOption.getType().equals("boolean"))
		booleanOptionsList.add(validOption.getName());
	}
	final Vector validOptions = validCommand.getValidOptions();
	for (int ii=0; ii<validOptions.size(); ii++)
	{
	    final ValidOption validOption = (ValidOption)validOptions.get(ii);
	    if (validOption.getType().equals("boolean"))
		booleanOptionsList.add(validOption.getName());
	}
	return booleanOptionsList;
    }
    

        /**
         *  This api will check if the user enters an operand, if not, then
         *  replace it with the defaultoperand specified in the
         *  CLIDescriptor.xml
         */
    private static Vector determineOperand(Vector operands, String defaultOperand)
    {
        return operands.size()<1 && defaultOperand!=null ?
               new Vector(java.util.Arrays.asList(
               new String[]{defaultOperand})):operands;
    }
    
}
