/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import javax.management.MBeanServerConnection;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import java.util.Iterator;
import java.util.Set;
import java.util.Map;

public class ListTransformationRulesCommand extends BaseTransformationRuleCommand
{
    private static final String WEB_SERVICE_OPTION = "webservicename";
   
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        validateOptions();
        try
        { 
            MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                                  getUser(), getPassword());
            //DomainRoot domainRoot = ProxyFactory.getInstance(mbsc).getDomainRoot();
            //final Set s = domainRoot.getQueryMgr().queryJ2EETypeSet(XTypes.WEB_SERVICE_ENDPOINT_CONFIG);
            String webServiceName = getOption(WEB_SERVICE_OPTION);
            validateWebServiceName(webServiceName, false);
            boolean nothingToList = listTransformationRules(mbsc);
            if (nothingToList)
            {
                CLILogger.getInstance().printMessage(getLocalizedString("NoElementsToList"));
            }
	    CLILogger.getInstance().printDetailMessage(getLocalizedString(
						       "CommandSuccessful",
						       new Object[] {name}));
        }
        catch(Exception e)
        {
            displayExceptionMessage(e);
        }        
    
    }


    /**
     *  Iterates throught WSEP config to find the transformation rules.
     *  @throws CommandException
     */
    private boolean listTransformationRules(MBeanServerConnection mbsc) 
                    throws CommandException, CommandValidationException
    {
        String webServiceName = getOption(WEB_SERVICE_OPTION);
        if (webServiceName != null)
        {
            WebServiceEndpointConfig wsc = 
                    getWebServiceEndpointConfig(mbsc, webServiceName, false);
            if (wsc == null)
                throw new CommandException(getLocalizedString("CannotFindWebservice"));
            return displayTransformationRules(wsc);
        }
        DomainRoot domainRoot = ProxyFactory.getInstance(mbsc).getDomainRoot();
        final Set s = domainRoot.getQueryMgr().queryJ2EETypeSet(XTypes.WEB_SERVICE_ENDPOINT_CONFIG);
        final Iterator iter = s.iterator();
        boolean nothingToList = true;
        while (iter.hasNext() )
        {
            final WebServiceEndpointConfig wsc = (WebServiceEndpointConfig)iter.next();
            if (wsc.getTransformationRuleConfigMap().size() > 0)
            {
                CLILogger.getInstance().printMessage(wsc.getName());
                nothingToList = displayTransformationRules(wsc);
            }
        }
        return nothingToList;
    }


    /**
     *  Display the transformation rules.
     *  @throws CommandException
     */
    private boolean displayTransformationRules(WebServiceEndpointConfig wsc) 
                    throws CommandException
    {
        Map rules = wsc.getTransformationRuleConfigMap();
        for (Object key : rules.keySet())
        {
            CLILogger.getInstance().printMessage((String)key);
        }
        if (rules.size() > 0) 
            return false;
        else
            return true;
    }
}
