/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

/**
 *  This command will get the version of the application server
 *  @version  $Revision: 1.4 $ 
 */
public class GenerateJVMReportCommand extends GenericCommand
{

    private static final String SUMMARY_OPERATION = "getSummary";
    private static final String CLASS_OPERATION = "getClassInformation";
    private static final String MEMORY_OPERATION = "getMemoryInformation";
    private static final String THREADDUMP_OPERATION = "getThreadDump";
    private static final String TYPE_OPTION = "type";
    private String typeOption;

    /**
     *  An abstract method that validates the options
     *  on the specification in the xml properties file
     *  This method verifies for the correctness of number of
     *  operands and if all the required options are supplied by the client.
     *  @return boolean returns true if success else returns false
     */
    public boolean validateOptions() throws CommandValidationException
    {
        if (!super.validateOptions()) 
            return false;

        typeOption = getOption(TYPE_OPTION);
        if (typeOption.matches("summary|memory|class|thread"))
        {
            return true;
        }
        else
        {
              throw new CommandValidationException(getLocalizedString(
                                                     "InvalidTypeOption"));
        }
    }


    /*
     * Returns the Operation name from the properties
     * @return operationName returns operation name
     */
    protected String getOperationName() throws CommandException
    {
        String operationName = SUMMARY_OPERATION;
        if (typeOption.equals("memory")) 
            operationName = MEMORY_OPERATION;
        else if (typeOption.equals("class"))
            operationName = CLASS_OPERATION;
        else if (typeOption.equals("thread"))
            operationName = THREADDUMP_OPERATION;
        return operationName;
    }

    protected void handleReturnValue(Object returnval)
    {
        final Class cl = returnval.getClass();
        if (cl.getName().equals(String.class.getName()))
        {
            final String returnString = (String)returnval;
	        CLILogger.getInstance().printMessage(returnString);
	    }
    }

}
