/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

public class CreatePersistenceResourceCommand extends GenericCommand
{
    private final static String JDBC_JNDI_NAME = "jdbcjndiname";
    private final static String POOL_NAME = "connectionpoolid";
    
    public boolean validateOptions() throws CommandValidationException 
    {
        //Check if both jdbc-resource-jndi-name and connection-pool name is provided.
        if (getOption(JDBC_JNDI_NAME) != null && getOption(POOL_NAME) != null)
            throw new CommandValidationException(getLocalizedString("MutuallyExclusiveOption", 
						                     new Object[] { JDBC_JNDI_NAME,  
								     POOL_NAME })); 

        return super.validateOptions();
    }
}
