/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import com.sun.enterprise.config.serverbeans.ServerTags;
import java.util.Map;
import java.util.HashMap;

public class CreateMBeanCommand extends GenericCommand 
{
    
    public final static String TARGET_OPTION = "target";
    public final static String NAME_OPTION = "name";
    public final static String OBJECT_NAME_OPTION = "objectname";
    public final static String ATTRIBUTES_OPTION = "attributes";
    public final static String ATTRIBUTE_DELIMITER = ":";
    public final static String ATTRIBUTE_VALUE_DELIMITER = "=";

    /*
     * Returns the Params from the properties
     * @return params returns params
     */
    protected Object[] getParamsInfo()throws CommandException, CommandValidationException
    {
        Object[] paramsInfo = new Object[3];
        paramsInfo[0] = getOption(TARGET_OPTION);
        Map mbeanParams = new HashMap();
        if (getOption(NAME_OPTION) != null)
            mbeanParams.put(ServerTags.NAME, getOption(NAME_OPTION));
        if (getOption(OBJECT_NAME_OPTION) != null)
            mbeanParams.put(ServerTags.OBJECT_NAME, getOption(OBJECT_NAME_OPTION));
        mbeanParams.put(ServerTags.IMPL_CLASS_NAME, getOperands().get(0));
        paramsInfo[1] = mbeanParams;
        paramsInfo[2] = getAttributesList(getOption(ATTRIBUTES_OPTION));
        return paramsInfo;
    }

    
    /**
     * Formulate and Returns Properties from the given string
     * @return Properties
     */
    private Map getAttributesList(String attributesStr)
        throws CommandException, CommandValidationException
    {
        Map attributes = new HashMap();
        if (attributesStr == null) return attributes;
        final CLITokenizer attrTok = new CLITokenizer(attributesStr, ATTRIBUTE_DELIMITER);
        while (attrTok.hasMoreTokens()) {
            final String nameAndvalue = attrTok.nextToken();
            final CLITokenizer nameTok = new CLITokenizer(nameAndvalue, ATTRIBUTE_VALUE_DELIMITER);
            if (nameTok.countTokens() == 2)
            {
                attributes.put(nameTok.nextTokenWithoutEscapeAndQuoteChars(),
                               nameTok.nextTokenWithoutEscapeAndQuoteChars());
            }
            else
            {
                throw new CommandValidationException(getLocalizedString("InvalidAttributeSyntax"));
            }
        }
        CLILogger.getInstance().printDebugMessage("Got the Attributes List : " + attributes.toString());
        return attributes;
    }
}
