/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/ArgHelper.java,v 1.3 2005/12/25 03:45:26 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:26 $
 */
 
package com.sun.cli.jmx.cmd;


public interface ArgHelper
{
	public interface OptionsInfo
	{
		public String		tokenToOptionName( String token );
		public String		tokenToOptionData( String token );
		public boolean		isLegalOption( String token );
		public boolean		isBoolean( String token );
		public int			getNumValues( String token );
	};
	
	public static final class IllegalOptionException extends Exception
	{
			public
		IllegalOptionException( String msg )
		{
			super( msg );
		}
	}
	
	/*
		Return the value string associated with the option
	 */
	public String		getArgValue( String name )
							throws IllegalOptionException;
	public String []	getArgValues( String name  )
							throws IllegalOptionException;
	
	public int			countOptions();
	
	public String		getString( String name, String defaultValue)
							throws IllegalOptionException;
	
	public Integer		getInteger( String name )
							throws IllegalOptionException;
	
	public Boolean		getBoolean( String name, Boolean defaultValue)
							throws IllegalOptionException;
	
	public String []	getOperands( );
};



