/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.jmx.stringifier.NotificationStringifier;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.enterprise.management.DomainRootImpl;
import com.sun.enterprise.management.support.BootUtil;
import com.sun.enterprise.management.support.DeferRegistrationException;
import com.sun.enterprise.management.support.LoaderBase;
import com.sun.enterprise.management.support.LoaderOfOld;
import com.sun.enterprise.management.support.LoaderOfOld77;
import com.sun.enterprise.management.support.LoaderOfOldConfig;
import com.sun.enterprise.management.support.LoaderOfOldMonitor;
import com.sun.enterprise.management.support.LoaderRegThread;
import com.sun.enterprise.management.support.MBeanImplBase;
import com.sun.enterprise.management.support.SystemInfoImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.ObjectName;

public final class Loader
extends LoaderBase {
    private boolean mQueuedAll = false;
    private List<LoaderOfOld> mLoaders = null;
    private Map<ObjectName, ObjectName> mOldToNewObjectNames = Collections.synchronizedMap(new HashMap());
    private LoaderRegThread mRegThread = null;
    private final DeferredRegistrationThread mDeferredRegistrationThread = new DeferredRegistrationThread();
    private static final boolean SYNCHRONOUS_NOTIFICATION_HANDLING = true;
    private static final long WAIT_THRESHOLD_MILLIS = 5000L;

    public Loader() {
        this.mDeferredRegistrationThread.start();
    }

    protected void preRegisterHook() {
        this.mRegThread = new LoaderRegThread(this, this.mLogger);
        this.mRegThread.start();
    }

    public void handleNotification(Notification notifIn, Object handback) {
        String type = notifIn.getType();
        if (notifIn instanceof MBeanServerNotification) {
            this.trace("Loader.handleNotification: received: " + NotificationStringifier.toString(notifIn));
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
            if (this.shouldSync(objectName)) {
                boolean register;
                boolean bl = register = type == "JMX.mbean.registered";
                if (register) {
                    this.mRegThread.processRegistration(objectName);
                } else {
                    this.mRegThread.processUnregistration(objectName);
                }
            }
        }
    }

    public void handleMBeanRegistered(ObjectName oldObjectName) throws InstanceNotFoundException {
        block5: {
            this.trace("handleMBeanRegistered: " + oldObjectName);
            if (this.shouldSync(oldObjectName)) {
                long start = Loader.now();
                while (!this.getMBeanServer().isRegistered(oldObjectName) && Loader.now() - start < 5000L) {
                    this.mySleep(50L);
                }
                if (!this.getMBeanServer().isRegistered(oldObjectName)) {
                    this.trace("Loader.handleMBeanRegistered: not found!!!");
                    throw new InstanceNotFoundException(oldObjectName.toString());
                }
                try {
                    this.sync(oldObjectName);
                }
                catch (Exception e) {
                    Throwable rootCause = ExceptionUtil.getRootCause(e);
                    if (!(rootCause instanceof DeferRegistrationException)) break block5;
                    this.mDeferredRegistrationThread.defer(oldObjectName);
                }
            }
        }
    }

    public void handleMBeanUnregistered(ObjectName oldObjectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.trace("handleMBeanUnregistered: " + oldObjectName);
        ObjectName newObjectName = this.mOldToNewObjectNames.remove(oldObjectName);
        if (newObjectName != null && this.getMBeanServer().isRegistered(newObjectName)) {
            this.debug((Object)("unregistering: " + newObjectName + " corresponding to " + oldObjectName));
            this.getMBeanServer().unregisterMBean(newObjectName);
        }
    }

    synchronized ObjectName registerNew(Object impl, ObjectName implObjectName, ObjectName oldObjectName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        this.debug((Object)("registering: " + implObjectName + " corresponding to " + oldObjectName));
        ObjectName resultName = this.getMBeanServer().registerMBean(impl, implObjectName).getObjectName();
        this.mOldToNewObjectNames.put(oldObjectName, resultName);
        return resultName;
    }

    public ObjectName loadSystemInfo(MBeanServer server) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        BootUtil bootUtil = BootUtil.getInstance();
        SystemInfoImpl systemInfo = new SystemInfoImpl(server, bootUtil);
        ObjectName tempName = this.mObjectNames.getSingletonObjectName("X-SystemInfo");
        ObjectName objectName = this.mServer.registerMBean(systemInfo, tempName).getObjectName();
        this.debug((Object)"loaded SystemInfo");
        return objectName;
    }

    private void addLoaders() {
        assert (this.getMBeanServer() != null);
        assert (this.getMBeanLogger() != null);
        ArrayList<LoaderOfOld> loaders = new ArrayList<LoaderOfOld>();
        loaders.add(new LoaderOfOldConfig(this));
        loaders.add(new LoaderOfOld77(this));
        loaders.add(new LoaderOfOldMonitor(this));
        this.mLoaders = Collections.unmodifiableList(loaders);
    }

    private boolean shouldSync(ObjectName oldObjectName) {
        return this.findLoaderOfOld(oldObjectName) != null;
    }

    private LoaderOfOld findLoaderOfOld(ObjectName candidate) {
        LoaderOfOld oldLoader = null;
        for (LoaderOfOld loo : this.mLoaders) {
            if (!loo.shouldSync(candidate)) continue;
            oldLoader = loo;
            break;
        }
        return oldLoader;
    }

    public ObjectName sync(ObjectName oldObjectName) {
        if (!this.mStarted) {
            throw new IllegalArgumentException();
        }
        if (!this.shouldSync(oldObjectName)) {
            throw new IllegalArgumentException(oldObjectName.toString());
        }
        long millis = 200L;
        while (!this.getMBeanServer().isRegistered(oldObjectName)) {
            this.mySleep(millis);
            if ((millis *= 2L) <= 500L) continue;
            this.getMBeanLogger().info("Loader.sync: waiting for MBean to load: " + oldObjectName);
        }
        ObjectName result = null;
        try {
            LoaderOfOld loaderOfOld = this.findLoaderOfOld(oldObjectName);
            if (loaderOfOld != null && (result = loaderOfOld.syncWithOld(oldObjectName)) == null) {
                throw new IllegalArgumentException(oldObjectName.toString());
            }
        }
        catch (Exception e) {
            String msg = ExceptionUtil.toString(e);
            this.debug((Object)msg);
            this.getMBeanLogger().fine(msg);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return result;
    }

    private void queueAll() {
        for (LoaderOfOld oldLoader : this.mLoaders) {
            List oldObjectNames = oldLoader.findAllOld();
            this.mRegThread.enqueue(true, oldObjectNames);
            this.getMBeanLogger().fine("Loader: Queued " + oldObjectNames.size() + " MBeans for loader " + oldLoader.getClass().getName());
        }
    }

    protected void startHook() {
        super.startHook();
        this.addLoaders();
        this.queueAll();
        this.mQueuedAll = true;
    }

    public boolean isStarted() {
        return super.isStarted() && this.mQueuedAll && this.mRegThread.getRegistrationQueueSize() == 0;
    }

    protected Object createDomainRoot() {
        return new DomainRootImpl();
    }

    public boolean isDAS() {
        return true;
    }

    public ObjectName resyncAMXMBean(ObjectName amx) throws InstanceNotFoundException, MBeanRegistrationException {
        if (!this.getMBeanServer().isRegistered(amx)) {
            throw new InstanceNotFoundException();
        }
        if (!this.getAMXJMXDomainName().equals(amx.getDomain())) {
            throw new IllegalArgumentException("" + amx);
        }
        this.debug((Object)"resyncAMXMBean: looking for matching delegate MBean");
        ObjectName old = null;
        for (ObjectName oldTemp : this.mOldToNewObjectNames.keySet()) {
            if (!this.mOldToNewObjectNames.get(oldTemp).equals(amx)) continue;
            old = oldTemp;
            this.debug((Object)("resyncAMXMBean: found matching delegate MBean: " + old));
            break;
        }
        if (old == null) {
            throw new IllegalArgumentException("" + amx);
        }
        this.debug((Object)("resyncAMXMBean: removing mapping from: " + old + " TO " + amx));
        this.mOldToNewObjectNames.remove(old);
        this.debug((Object)("resyncAMXMBean: unregistering: " + amx));
        this.getMBeanServer().unregisterMBean(amx);
        this.debug((Object)("resyncAMXMBean: handleMBeanRegistered: " + amx));
        this.handleMBeanRegistered(old);
        ObjectName newAMX = this.mOldToNewObjectNames.get(old);
        assert (newAMX != null);
        this.debug((Object)("resyncAMXMBean: new ObjectName: " + newAMX));
        return newAMX;
    }

    private final class DeferredRegistrationThread
    extends Thread {
        private final List<DeferredItem> mDeferredItems = Collections.synchronizedList(new ArrayList());
        private boolean mSleeping = false;
        private final long RETRY_INTERVAL_MILLIS = 1000L;
        private final long MAX_DELAY_MILLIS = 60000L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void internalDefer(DeferredItem item) {
            List<DeferredItem> list = this.mDeferredItems;
            synchronized (list) {
                this.mDeferredItems.add(item);
            }
        }

        public synchronized void defer(ObjectName oldObjectName) {
            Loader.this.logFine("Deferring registration for " + MBeanImplBase.quote(oldObjectName));
            this.internalDefer(new DeferredItem(oldObjectName));
            if (this.mSleeping) {
                this.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DeferredItem[] takeAllItems() {
            List<DeferredItem> list = this.mDeferredItems;
            synchronized (list) {
                DeferredItem[] items = new DeferredItem[this.mDeferredItems.size()];
                this.mDeferredItems.toArray(items);
                this.mDeferredItems.clear();
                return items;
            }
        }

        private ObjectName retry(ObjectName oldObjectName) {
            return Loader.this.sync(oldObjectName);
        }

        private void retryItem(DeferredItem item) {
            ObjectName oldObjectName = item.mObjectName;
            String prefix = "DeferredRegistrationThread.retryItem: ";
            long elapsed = LoaderBase.now() - item.mStartMillis;
            try {
                ObjectName result = this.retry(oldObjectName);
                String msg = "DeferredRegistrationThread.retryItem: deferred registration SUCCEEDED after " + elapsed + " milliseconds for " + MBeanImplBase.quote(oldObjectName) + ", amx ObjectName = " + MBeanImplBase.quote(result);
                Loader.this.getMBeanLogger().info(msg);
            }
            catch (Throwable t) {
                Throwable rootCause = ExceptionUtil.getRootCause(t);
                if (rootCause instanceof DeferRegistrationException) {
                    if (elapsed < 60000L) {
                        Loader.this.logWarning("DeferredRegistrationThread.retryItem: deferred registration RETRY failed after " + elapsed + " milliseconds for " + MBeanImplBase.quote(oldObjectName) + " (DEFERRING AGAIN)");
                        this.internalDefer(item);
                    } else {
                        Loader.this.logWarning("DeferredRegistrationThread.retryItem: Deferred registration FAILED for " + MBeanImplBase.quote(oldObjectName) + "after deferral of " + elapsed + " ms, ignoring MBean.");
                    }
                }
                Loader.this.logWarning("DeferredRegistrationThread.retryItem: Deferred registration FAILED for " + MBeanImplBase.quote(oldObjectName) + "due to Exception of type " + rootCause.getClass().getName());
            }
        }

        private void checkList() {
            DeferredItem[] items = this.takeAllItems();
            Loader.this.logFine("DeferredRegistrationThread.checkList: numItems = " + items.length);
            for (int i = 0; i < items.length; ++i) {
                DeferredItem item = items[i];
                if (Loader.this.getMBeanServer().isRegistered(item.mObjectName)) {
                    this.retryItem(item);
                    continue;
                }
                Loader.this.logInfo("DeferredRegistrationThread.checkList: MBean is no longer registered: " + MBeanImplBase.quote(item.mObjectName));
            }
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Loader.this.getMBeanLogger().fine("DeferredRegistrationThread.run: CHECKING LIST@" + LoaderBase.now());
                        this.checkList();
                        long sleepMillis = this.mDeferredItems.size() == 0 ? 60000L : 1000L;
                        Loader.this.getMBeanLogger().fine("DeferredRegistrationThread.run: SLEEPING FOR: " + sleepMillis + "@" + LoaderBase.now());
                        this.mSleeping = true;
                        boolean interrupted = Loader.this.mySleep(sleepMillis);
                        this.mSleeping = false;
                    }
                }
                catch (Throwable t) {
                    Loader.this.getMBeanLogger().warning("DeferredRegistrationThread.run: caught Throwable:\n" + ExceptionUtil.getStackTrace(t));
                    continue;
                }
                break;
            }
        }

        private final class DeferredItem {
            public long mStartMillis;
            public final ObjectName mObjectName;

            public DeferredItem(ObjectName objectName) {
                this.mObjectName = objectName;
                this.mStartMillis = LoaderBase.now();
            }
        }
    }
}

