/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.AMXRootLogger;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusterRefConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.monitor.LoadBalancerApplicationMonitor;
import com.sun.appserv.management.monitor.LoadBalancerClusterMonitor;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;
import com.sun.appserv.management.monitor.LoadBalancerServerMonitor;
import com.sun.appserv.management.util.jmx.MBeanRegistrationListener;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.ApplicationConfigHelper;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.management.monitor.LoadBalancerApplicationMonitorImpl;
import com.sun.enterprise.management.monitor.LoadBalancerClusterMonitorImpl;
import com.sun.enterprise.management.monitor.LoadBalancerContextRootMonitorImpl;
import com.sun.enterprise.management.monitor.LoadBalancerServerMonitorImpl;
import com.sun.enterprise.management.support.LBDeregistrationUtil;
import com.sun.enterprise.management.support.ObjectNames;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LBBaseMBeanRegistrationListener
extends MBeanRegistrationListener {
    final ObjectNames objectNames = ObjectNames.getInstance("amx");

    public LBBaseMBeanRegistrationListener(MBeanServer mBeanServer, ObjectName constraint) throws InstanceNotFoundException, IOException {
        super(mBeanServer, constraint);
    }

    public LBBaseMBeanRegistrationListener(MBeanServer mBeanServer) throws InstanceNotFoundException, IOException {
        this(mBeanServer, (ObjectName)null);
    }

    @Override
    public void mbeanUnregistered(ObjectName objectName) {
    }

    protected LoadBalancerClusterMonitor registerLoadBalancerClusterMonitor(LoadBalancerMonitor loadBalancerMonitor, String clusterName) throws JMException {
        ObjectName loadBalancerMonitorObjName = Util.getObjectName(loadBalancerMonitor);
        ObjectName childClusterRefObjectName = this.objectNames.buildContaineeObjectName(loadBalancerMonitorObjName, loadBalancerMonitor.getFullType(), "X-LoadBalancerClusterMonitor", clusterName);
        LoadBalancerClusterMonitorImpl loadBalancerClusterMonitorImpl = new LoadBalancerClusterMonitorImpl();
        try {
            ((MBeanServer)this.getConn()).registerMBean(loadBalancerClusterMonitorImpl, childClusterRefObjectName);
        }
        catch (JMException ex) {
            this.logWarning("LBBaseMBeanRegistrationListener registerLoadBalancerClusterMonitor failed. Exception = ", ex);
        }
        return this.getProxy(childClusterRefObjectName, LoadBalancerClusterMonitor.class);
    }

    protected LoadBalancerServerMonitor registerLoadBalancerServerMonitor(LoadBalancerClusterMonitor loadBalancerClusterMonitor, String serverName) throws JMException {
        ObjectName newChildClusterRefObjectName = Util.getObjectName(loadBalancerClusterMonitor);
        ObjectName childServerRefObjectName = this.objectNames.buildContaineeObjectName(newChildClusterRefObjectName, loadBalancerClusterMonitor.getFullType(), "X-LoadBalancerServerMonitor", serverName);
        LoadBalancerServerMonitorImpl loadBalancerServerMonitorImpl = new LoadBalancerServerMonitorImpl();
        try {
            ((MBeanServer)this.getConn()).registerMBean(loadBalancerServerMonitorImpl, childServerRefObjectName);
        }
        catch (JMException ex) {
            this.logWarning("LoadBalancerServerRefRegistrationListener registerLoadBalancerServerMonitor failed. Exception = ", ex);
        }
        return this.getProxy(childServerRefObjectName, LoadBalancerServerMonitor.class);
    }

    protected LoadBalancerApplicationMonitor registerLoadBalancerApplicationMonitor(LoadBalancerServerMonitor loadBalancerServerMonitor, String appName) throws JMException {
        ObjectName newChildServerRefObjectName = Util.getObjectName(loadBalancerServerMonitor);
        ObjectName childApplicationRefObjectName = this.objectNames.buildContaineeObjectName(newChildServerRefObjectName, loadBalancerServerMonitor.getFullType(), "X-LoadBalancerApplicationMonitor", appName);
        LoadBalancerApplicationMonitorImpl loadBalancerApplicationMonitorImpl = new LoadBalancerApplicationMonitorImpl();
        try {
            ((MBeanServer)this.getConn()).registerMBean(loadBalancerApplicationMonitorImpl, childApplicationRefObjectName);
        }
        catch (JMException ex) {
            this.logWarning("LoadBalancerServerRefRegistrationListener registerLoadBalancerApplicationMonitor failed. Exception = ", ex);
        }
        return this.getProxy(childApplicationRefObjectName, LoadBalancerApplicationMonitor.class);
    }

    protected void registerLoadBalancerContextRootMonitor(LoadBalancerApplicationMonitor loadBalancerApplicationMonitor, String ctxRootName) throws JMException {
        ObjectName newChildAppRefObjectName = Util.getObjectName(loadBalancerApplicationMonitor);
        ObjectName childContextRootObjectName = this.objectNames.buildContaineeObjectName(newChildAppRefObjectName, loadBalancerApplicationMonitor.getFullType(), "X-LoadBalancerContextRootMonitor", ctxRootName);
        LoadBalancerContextRootMonitorImpl loadBalancerContextRootMonitorImpl = new LoadBalancerContextRootMonitorImpl();
        ((MBeanServer)this.getConn()).registerMBean(loadBalancerContextRootMonitorImpl, childContextRootObjectName);
    }

    protected List<LoadBalancerMonitor> fetchLBMonitoringRoots(LBConfig lbConfig) throws JMException {
        ArrayList<LoadBalancerMonitor> monitoringRoots = new ArrayList<LoadBalancerMonitor>();
        String name = lbConfig.getName();
        Map<String, LoadBalancerConfig> loadBalancerConfigMap = this.getDomainConfig().getLoadBalancerConfigMap();
        HashMap<String, LoadBalancerConfig> relatedLoadBalancerConfigMap = new HashMap<String, LoadBalancerConfig>();
        for (String loadBalancerName : loadBalancerConfigMap.keySet()) {
            LoadBalancerConfig loadBalancerConfig = loadBalancerConfigMap.get(loadBalancerName);
            if (!loadBalancerConfig.getLbConfigName().equals(name)) continue;
            relatedLoadBalancerConfigMap.put(loadBalancerName, loadBalancerConfig);
            monitoringRoots.add(this.fetchMonitoringPeer(loadBalancerConfig));
        }
        return monitoringRoots;
    }

    protected ProxyFactory getProxyFactory() {
        return ProxyFactory.getInstance(this.getConn());
    }

    protected <T extends AMX> T getProxy(ObjectName objectName, Class<T> theClass) {
        return this.getProxyFactory().getProxy(objectName, theClass);
    }

    protected LoadBalancerMonitor fetchMonitoringPeer(LoadBalancerConfig loadBalancerConfig) throws JMException {
        String name = loadBalancerConfig.getName();
        ObjectName loadBalancerMonitorObjName = new ObjectName("amx:j2eeType=X-LoadBalancerMonitor,name=" + name);
        LoadBalancerMonitor loadBalancerMonitor = this.getProxy(loadBalancerMonitorObjName, LoadBalancerMonitor.class);
        return loadBalancerMonitor;
    }

    protected List<LoadBalancerClusterMonitor> fetchLoadBalancerClusterMonitors(List<LoadBalancerMonitor> monitoringRoots, String clusterName) {
        ArrayList<LoadBalancerClusterMonitor> result = new ArrayList<LoadBalancerClusterMonitor>();
        for (LoadBalancerMonitor monitoringRoot : monitoringRoots) {
            LoadBalancerClusterMonitor loadBalancerClusterMonitor = monitoringRoot.getLoadBalancerClusterMonitorMap().get(clusterName);
            if (loadBalancerClusterMonitor == null) continue;
            result.add(loadBalancerClusterMonitor);
        }
        return result;
    }

    protected Collection<LBConfig> fetchLBConfigs(String targetName, boolean isCluster) {
        HashMap<String, LBConfig> result = new HashMap<String, LBConfig>();
        Map<String, LBConfig> lbConfigMap = this.getDomainConfig().getLBConfigMap();
        if (isCluster) {
            block0: for (String lbConfigName : lbConfigMap.keySet()) {
                LBConfig lbConfig = lbConfigMap.get(lbConfigName);
                Map<String, ClusterRefConfig> lbClusterRefConfigMap = lbConfig.getClusterRefConfigMap();
                for (String clusterRef : lbClusterRefConfigMap.keySet()) {
                    if (!clusterRef.equals(targetName)) continue;
                    result.put(lbConfigName, lbConfig);
                    continue block0;
                }
            }
        } else {
            LBConfig lbConfig;
            block2: for (String lbConfigName : lbConfigMap.keySet()) {
                lbConfig = lbConfigMap.get(lbConfigName);
                Map<String, ServerRefConfig> lbServerRefConfigMap = lbConfig.getServerRefConfigMap();
                for (String serverRef : lbServerRefConfigMap.keySet()) {
                    if (!serverRef.equals(targetName)) continue;
                    result.put(lbConfigName, lbConfig);
                    continue block2;
                }
            }
            for (String lbConfigName : lbConfigMap.keySet()) {
                lbConfig = lbConfigMap.get(lbConfigName);
                Map<String, ClusterRefConfig> lbClusterRefConfigMap = lbConfig.getClusterRefConfigMap();
                Map<String, ClusterConfig> clusterConfigMap = this.getDomainConfig().getClusterConfigMap();
                HashMap<String, ClusterConfig> relevantClusterConfigMap = new HashMap<String, ClusterConfig>();
                for (String clusterRef : lbClusterRefConfigMap.keySet()) {
                    relevantClusterConfigMap.put(clusterRef, clusterConfigMap.get(clusterRef));
                }
                block6: for (String clusterName : relevantClusterConfigMap.keySet()) {
                    ClusterConfig clusterConfig = (ClusterConfig)relevantClusterConfigMap.get(clusterName);
                    Map<String, ServerRefConfig> clusteredServerRefConfigMap = clusterConfig.getServerRefConfigMap();
                    for (String serverRef : clusteredServerRefConfigMap.keySet()) {
                        if (!serverRef.equals(targetName)) continue;
                        result.put(lbConfigName, lbConfig);
                        continue block6;
                    }
                }
            }
        }
        return result.values();
    }

    protected void registerLoadBalancerApplicationMonitorTree(LoadBalancerServerMonitor loadBalancerServerMonitor, String appName) throws JMException {
        try {
            String[] ctxRootNames;
            if (ApplicationHelper.isSystemApp((ConfigContext)DeploymentServiceUtils.getConfigContext(), (String)appName)) {
                return;
            }
            LoadBalancerApplicationMonitor loadBalancerApplicationMonitor = this.registerLoadBalancerApplicationMonitor(loadBalancerServerMonitor, appName);
            for (String ctxRootName : ctxRootNames = ApplicationConfigHelper.getAppContextRoots((ConfigContext)DeploymentServiceUtils.getConfigContext(), (String)appName)) {
                this.registerLoadBalancerContextRootMonitor(loadBalancerApplicationMonitor, ctxRootName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void registerLoadBalancerServerMonitorTree(LoadBalancerClusterMonitor loadBalancerClusterMonitor, Map<String, ServerConfig> serverConfigMap, String serverName) throws JMException {
        LoadBalancerServerMonitor loadBalancerServerMonitor = this.registerLoadBalancerServerMonitor(loadBalancerClusterMonitor, serverName);
        ServerConfig serverConfig = serverConfigMap.get(serverName);
        Map<String, DeployedItemRefConfig> deployedItemRefConfigMap = serverConfig.getDeployedItemRefConfigMap();
        for (String appName : deployedItemRefConfigMap.keySet()) {
            try {
                String[] ctxRootNames;
                if (ApplicationHelper.isSystemApp((ConfigContext)DeploymentServiceUtils.getConfigContext(), (String)appName)) continue;
                LoadBalancerApplicationMonitor loadBalancerApplicationMonitor = this.registerLoadBalancerApplicationMonitor(loadBalancerServerMonitor, appName);
                for (String ctxRootName : ctxRootNames = ApplicationConfigHelper.getAppContextRoots((ConfigContext)DeploymentServiceUtils.getConfigContext(), (String)appName)) {
                    if (ctxRootName.startsWith("/")) {
                        ctxRootName = ctxRootName.substring(1);
                    }
                    this.registerLoadBalancerContextRootMonitor(loadBalancerApplicationMonitor, ctxRootName);
                }
            }
            catch (ConfigException ex) {
                this.logWarning("LoadBalancerServerRefRegistrationListener registerLoadBalancerServerMonitorTree failed. Exception = ", (Exception)((Object)ex));
            }
            catch (IASDeploymentException ex) {
                this.logWarning("LoadBalancerServerRefRegistrationListener registerLoadBalancerServerMonitorTree failed. Exception = ", (Exception)((Object)ex));
            }
        }
    }

    protected void registerLoadBalancerClusterMonitorTree(LoadBalancerMonitor lbm, String clusterName) throws JMException {
        LoadBalancerClusterMonitor lbcm = this.registerLoadBalancerClusterMonitor(lbm, clusterName);
        Map<String, ClusterConfig> clusterConfigMap = this.getDomainConfig().getClusterConfigMap();
        ClusterConfig clusterConfig = clusterConfigMap.get(clusterName);
        Map<String, ClusteredServerConfig> cServerConfigMap = clusterConfig.getClusteredServerConfigMap();
        HashMap<String, ServerConfig> serverConfigMap = new HashMap<String, ServerConfig>();
        for (String key : cServerConfigMap.keySet()) {
            serverConfigMap.put(key, cServerConfigMap.get(key));
        }
        for (String serverName : serverConfigMap.keySet()) {
            this.registerLoadBalancerServerMonitorTree(lbcm, serverConfigMap, serverName);
        }
    }

    protected DomainConfig getDomainConfig() {
        return ProxyFactory.getInstance(this.getConn()).getDomainRoot().getDomainConfig();
    }

    protected LBDeregistrationUtil getLBDeregistrationUtil(MBeanServer mBeanServer) {
        return LBDeregistrationUtil.getInstance(mBeanServer);
    }

    protected void debug(Object o) {
        if (o instanceof Throwable) {
            ((Throwable)o).printStackTrace();
        }
        AMXDebug.getInstance().getOutput("TestLoadBalancerLoad").println(StringUtil.toString(", ", o));
    }

    protected void logWarning(String prefix, Exception ex) {
        AMXRootLogger.getInstance().warning(prefix + " : " + ex.getMessage());
    }
}

