/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.enterprise.management.offline.OfflineDottedNamePrefixes;
import com.sun.enterprise.management.offline.OfflineDottedNamesRegistry;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class OfflineDottedNamesMgr {
    private final OfflineDottedNamesRegistry mRegistry;
    private final OfflineDottedNamePrefixes mPrefixes;
    private final MBeanServer mServer;
    private final String WILD_ALL = "*";

    public OfflineDottedNamesMgr(MBeanServer server) {
        this.mServer = server;
        this.mRegistry = new OfflineDottedNamesRegistry();
        this.mPrefixes = OfflineDottedNamePrefixes.getInstance();
    }

    private void debug(Object o) {
        AMXDebug.getInstance().getOutput("OfflineDottedNamesMgr").println(o);
    }

    private String getPrefix(String dottedName) {
        int idx = dottedName.lastIndexOf(dottedName);
        if (idx <= 0) {
            throw new IllegalArgumentException(dottedName);
        }
        return dottedName.substring(0, idx - 1);
    }

    private String getAttrName(String dottedName) {
        String prefix = this.getPrefix(dottedName);
        return dottedName.substring(prefix.length() + 1, dottedName.length());
    }

    public void refresh() {
    }

    public Object[] dottedNameGet(String[] names) {
        Object[] results = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                results[i] = this.dottedNameGet(names[i]);
                continue;
            }
            catch (Exception e) {
                results[i] = e;
            }
        }
        return results;
    }

    public Object dottedNameGet(String dottedName) {
        String prefix = this.getPrefix(dottedName);
        ObjectName objectName = this.mRegistry.getObjectName(prefix);
        if (objectName == null) {
            throw new IllegalArgumentException(dottedName);
        }
        String attrName = this.getAttrName(dottedName);
        this.debug("dottedNameGet: " + dottedName + ", prefix = " + prefix + "attrName = " + attrName);
        Object value = null;
        try {
            value = this.mServer.getAttribute(objectName, attrName);
        }
        catch (Exception e) {
            value = e;
        }
        this.debug("dottedNameGet: " + dottedName + " = " + value);
        return value;
    }

    public Object[] dottedNameList(String[] names) {
        return new String[0];
    }

    public Object[] dottedNameSet(String[] nameValuePairs) {
        for (String pair : nameValuePairs) {
        }
        throw new UnsupportedOperationException("dottedNameSet");
    }
}

