/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OfflineDottedNamePrefixes {
    private final Map<String, String[]> mTemplates = this.initTemplates();
    private static OfflineDottedNamePrefixes INSTANCE = null;
    private static final String VAR = "$";
    private static final String PAR = "^";
    private static final String PART_DELIM = ".";
    private static final String NAME_VAR = OfflineDottedNamePrefixes.VAR("name");
    private static final Object[] TEMPLATES = new Object[]{"X-DomainConfig", new String[]{"domain"}, "X-ConfigConfig", new String[]{NAME_VAR}, "X-StandaloneServerConfig", new String[]{NAME_VAR}, "X-HTTPServiceConfig", new String[]{OfflineDottedNamePrefixes.VAR("X-ConfigConfig"), "http-service"}, "X-IIOPServiceConfig", new String[]{OfflineDottedNamePrefixes.VAR("X-ConfigConfig"), "iiop-service"}, "X-AdminServiceConfig", new String[]{OfflineDottedNamePrefixes.VAR("X-ConfigConfig"), "admin-service"}, "X-JavaConfig", new String[]{OfflineDottedNamePrefixes.VAR("X-ConfigConfig"), "java"}, "X-AvailabilityServiceConfig", new String[]{OfflineDottedNamePrefixes.VAR("X-ConfigConfig"), "availability"}, "X-EJBContainerConfig", new String[]{OfflineDottedNamePrefixes.VAR("X-ConfigConfig"), "ejb-container"}, "X-HTTPListenerConfig", new String[]{OfflineDottedNamePrefixes.PAR("X-HTTPServiceConfig"), "listeners", NAME_VAR}, "X-AccessLogConfig", new String[]{OfflineDottedNamePrefixes.PAR("X-HTTPServiceConfig"), "access-log"}, "X-KeepAliveConfig", new String[]{OfflineDottedNamePrefixes.PAR("X-HTTPServiceConfig"), "keep-alive"}, "X-RequestProcessingConfig", new String[]{OfflineDottedNamePrefixes.PAR("X-HTTPServiceConfig"), "request-processing"}, "X-ConnectionPoolConfig", new String[]{OfflineDottedNamePrefixes.PAR("X-HTTPServiceConfig"), "connection-pool"}, "X-HTTPProtocolConfig", new String[]{OfflineDottedNamePrefixes.PAR("X-HTTPServiceConfig"), "http-protocol"}, "X-HTTPFileCacheConfig", new String[]{OfflineDottedNamePrefixes.PAR("X-HTTPServiceConfig"), "file-cache"}, "X-VirtualServerConfig", new String[]{OfflineDottedNamePrefixes.PAR("X-HTTPServiceConfig"), "virtual-servers", NAME_VAR}};

    private OfflineDottedNamePrefixes() {
    }

    public static synchronized OfflineDottedNamePrefixes getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OfflineDottedNamePrefixes();
        }
        return INSTANCE;
    }

    private static String PAR(String s) {
        return PAR + s;
    }

    private static String VAR(String s) {
        return VAR + s;
    }

    private static String varName(String s) {
        if (!s.startsWith(VAR)) {
            throw new IllegalArgumentException(s);
        }
        return s.substring(VAR.length(), s.length());
    }

    private Map<String, String[]> initTemplates() {
        HashMap<String, String[]> templates = new HashMap<String, String[]>();
        for (int i = 0; i < TEMPLATES.length; i += 2) {
            String j2eeType = (String)TEMPLATES[i];
            String[] template = (String[])TEMPLATES[i + 1];
            templates.put(j2eeType, template);
        }
        return templates;
    }

    private String concat(String prefix, String part) {
        String result = null;
        result = prefix == null || prefix.length() == 0 ? part : prefix + PART_DELIM + part;
        return result;
    }

    private String[] getTemplate(String j2eeType) {
        return this.mTemplates.get(j2eeType);
    }

    public String getPrefix(ObjectName objectName) {
        String j2eeType = objectName.getKeyProperty("j2eeType");
        if (j2eeType == null) {
            throw new IllegalArgumentException("" + objectName);
        }
        String prefix = null;
        String[] template = this.getTemplate(j2eeType);
        if (template != null) {
            for (String part : template) {
                String value = null;
                if (part.startsWith(VAR)) {
                    String prop = OfflineDottedNamePrefixes.varName(part);
                    value = objectName.getKeyProperty(prop);
                    if (value == null) {
                        throw new IllegalArgumentException("No property " + prop + " in " + objectName);
                    }
                } else {
                    value = part;
                }
                prefix = this.concat(prefix, value);
            }
        }
        return prefix;
    }
}

