/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldLbConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClusterRefConfigFactory
extends ConfigFactory {
    private final OldLbConfig mOldLbConfigMBean;
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("LBPolicy", "LBPolicyModule");

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "ref");
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    public ClusterRefConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
        String containerName = this.getFactoryContainer().getName();
        this.mOldLbConfigMBean = this.getOldConfigProxies().getOldLbConfig(containerName);
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        return this.mOldLbConfigMBean.createClusterRef(translatedAttrs);
    }

    public ObjectName create(String referencedClusterName, Map<String, String> optional) {
        String[] requiredParams = new String[]{};
        Map<String, String> params = this.initParams(referencedClusterName, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(referencedClusterName, params);
        return amxName;
    }

    public ObjectName create(String referencedClusterName, String lbPolicy, String lbPolicyModule) {
        HashMap<String, String> optionalParams = new HashMap<String, String>();
        optionalParams.put("LBPolicy", lbPolicy);
        optionalParams.put("LBPolicyModule", lbPolicyModule);
        return this.create(referencedClusterName, optionalParams);
    }

    @Override
    public void removeByName(String referencedClusterName) {
        this.mOldLbConfigMBean.removeClusterRefByRef(referencedClusterName);
    }
}

