/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.serverbeans.validation.Frame;
import com.sun.enterprise.config.serverbeans.validation.Framer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class VariableExpander
extends XMLFilterImpl {
    Framer framer = new Framer();
    private static final String START = "${";
    private static final String END = "}";
    private StringBuffer characters = new StringBuffer();
    private Frame frame;
    private final boolean DEBUG = false;

    VariableExpander() {
    }

    VariableExpander(Framer f) {
        this.framer = f;
    }

    void setFramer(Framer f) {
        this.framer = f;
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.characters.append(ch, start, len);
    }

    public void endDocument() throws SAXException {
        this.processCharacters();
        this.framer.endDocument();
        super.endDocument();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.processCharacters();
        this.framer.endElement(namespaceURI, localName, qName);
        super.endElement(namespaceURI, localName, qName);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.processCharacters();
        this.framer.startElement(namespaceURI, localName, qName, atts);
        Attributes newAtts = this.processAttributes(atts);
        super.startElement(namespaceURI, localName, qName, newAtts);
    }

    private void processCharacters() throws SAXException {
        if (this.characters.length() > 0) {
            String chars = this.expandVariables(this.characters.toString());
            super.characters(chars.toCharArray(), 0, chars.length());
            this.characters.setLength(0);
        }
    }

    private String expandVariables(String chars) {
        return this.expandVariables(chars, this.framer.currentFrame());
    }

    private String expandVariables(String chars, Frame f) {
        return chars.indexOf(START) < chars.indexOf(END) ? this.eval(chars, f) : chars;
    }

    private Attributes processAttributes(Attributes atts) {
        AttributesImpl newAtts = new AttributesImpl(atts);
        for (int i = 0; i < newAtts.getLength(); ++i) {
            newAtts.setValue(i, this.expandVariables(newAtts.getValue(i)));
        }
        return newAtts;
    }

    String eval(String chars, Frame frame) {
        this.debug("expanding \"" + chars + "\"");
        StringBuffer sb = new StringBuffer();
        int ve = 0;
        int i = 0;
        while (i < chars.length()) {
            int vs = chars.indexOf(START, i);
            if (vs != -1 && (ve = chars.indexOf(END, i)) != -1) {
                sb.append(chars.substring(i, vs));
                sb.append(frame.lookup(chars.substring(vs + 2, ve)));
                i = ve + 1;
                continue;
            }
            sb.append(chars.substring(i));
            i = chars.length();
        }
        return sb.toString();
    }

    private final void debug(String s) {
    }
}

